package test.ee;


import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;


@WebServlet(name = "JdbcServlet", value = "/jdbc")
public class JdbcServlet extends HttpServlet {

    @Resource(name = "jdbc/DerbyTestXAPool")
    private DataSource dataSource;

    @Resource
    private UserTransaction utx;


    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        Writer out = response.getWriter();
        Connection conn = null;
        try {
//            utx.begin();
            out.write(utx.getStatus() + "\n");
            conn = dataSource.getConnection();
            out.write(conn.getAutoCommit() + "\n");
            conn.setAutoCommit(false);
            out.write(conn.getAutoCommit() + "\n");
            ResultSet rs = conn.createStatement().executeQuery("select max(id) from person");
            rs.next();
            long nextid = rs.getLong(1) + 1;

            out.write(conn.getAutoCommit() + "\n");
            PreparedStatement pst = conn.prepareStatement("insert into person(id, first_name, last_name) values(?, ?, ?)");
            out.write(conn.getAutoCommit() + "\n");
            pst.setLong(1, nextid);
            pst.setString(2, "fn" + nextid);
            pst.setString(3, "ln" + nextid);
            pst.execute();
            out.write(conn.getAutoCommit() + "\n");

            rs = conn.createStatement().executeQuery("select id, first_name, last_name from person");
            while (rs.next()) {
                long id = rs.getLong("id");
                String firstName = rs.getString("first_name");
                String lastName = rs.getString("last_name");
                out.write(String.format("[%d] %s %s\n", id, firstName, lastName));
            }
//            utx.commit();
            out.write(utx.getStatus() + "\n");
        } catch (Exception e) {
//            try {
//                utx.rollback();
//            } catch (SystemException e2) {
//                ignore
//            }
            throw new ServletException(e);
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    // ignore
                }
            }
        }
    }
}
