/*
 * Decompiled with CFR 0.152.
 */
package oosample.ui;

import com.sun.star.frame.XStorable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oosample.converter.DocConverter;
import oosample.ui.MyFilter;
import oosample.ui.TypeCheckBox;

public class ConvertDialog
extends JPanel
implements ActionListener {
    JLabel label;
    JFrame frame;
    String simpleDialogDesc = "File Types";
    JFileChooser fc;
    JButton runButton;
    JButton chooseDirButton;
    JTextField dirNameTextField = new JTextField(10);
    TypeCheckBox[] checkBoxes;
    JCheckBox subDirCheckBox;
    private FilenameFilter filter;
    private static final String FILE_SEP = System.getProperty("file.separator");
    final List word = new ArrayList();
    final List excel = new ArrayList();
    final List powerPoint = new ArrayList();
    final List images = new ArrayList();
    static String host;
    static String port;

    public ConvertDialog(JFrame frame) {
        super(new BorderLayout());
        this.word.add("doc");
        this.word.add("rtf");
        this.word.add("sxw");
        this.excel.add("xls");
        this.excel.add("sxc");
        this.powerPoint.add("ppt");
        this.powerPoint.add("sxi");
        this.images.add("bmp");
        this.images.add("gif");
        this.images.add("jpg");
        this.images.add("jpeg");
        this.images.add("tiff");
        this.fc = new JFileChooser();
        this.fc.setFileSelectionMode(2);
        this.frame = frame;
        JPanel choicePanel = this.createSimpleDialogBox();
        JLabel title = new JLabel("Click the \"run\" button once you have selected the file type you want to convert.", 0);
        choicePanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 5, 20));
        this.add((Component)title, "North");
        this.add((Component)choicePanel, "Center");
    }

    private JPanel createSimpleDialogBox() {
        int numCheckBox = 4;
        this.checkBoxes = new TypeCheckBox[4];
        this.subDirCheckBox = new JCheckBox("include sub directories ?");
        ButtonGroup group = new ButtonGroup();
        this.runButton = null;
        this.chooseDirButton = null;
        this.checkBoxes[0] = new TypeCheckBox("<html><font color=red>Word Document</font></html>");
        this.checkBoxes[0].setExtension(this.word);
        this.checkBoxes[1] = new TypeCheckBox("<html><font color=green>Excel Sheet</font></html>");
        this.checkBoxes[1].setExtension(this.excel);
        this.checkBoxes[2] = new TypeCheckBox("<html><font color=blue>Power Point</font></html>");
        this.checkBoxes[2].setExtension(this.powerPoint);
        this.checkBoxes[3] = new TypeCheckBox("<html><font color=maroon>Images</font></html>");
        this.checkBoxes[3].setExtension(this.images);
        this.runButton = new JButton("Run");
        this.chooseDirButton = new JButton("Choose a directory");
        this.chooseDirButton.addActionListener(this);
        this.runButton.addActionListener(this);
        System.out.println("calling createPane");
        return this.createPane(this.simpleDialogDesc + ":", this.checkBoxes, this.runButton, this.chooseDirButton, this.dirNameTextField, this.subDirCheckBox);
    }

    private JPanel createPane(String description, JCheckBox[] checkBoxes, JButton runButton, JButton chooseDirButton, JTextComponent dirNameTextField, JCheckBox subDirCheckBox) {
        int numChoices = checkBoxes.length;
        JPanel box = new JPanel();
        JLabel label = new JLabel(description);
        JPanel centerBox = new JPanel();
        centerBox.setLayout(new BoxLayout(centerBox, 2));
        centerBox.add(dirNameTextField);
        centerBox.add(subDirCheckBox);
        box.setLayout(new BoxLayout(box, 3));
        box.add(label);
        for (int i = 0; i < numChoices; ++i) {
            box.add(checkBoxes[i]);
        }
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)box, "North");
        pane.add((Component)chooseDirButton, "West");
        pane.add((Component)centerBox, "Center");
        pane.add((Component)runButton, "South");
        System.out.println("returning pane");
        return pane;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("Convert to PDF");
        frame.setDefaultCloseOperation(3);
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new GridLayout(1, 1));
        contentPane.add(new ConvertDialog(frame));
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            host = "localhost";
            port = "8100";
        } else {
            host = args[0];
            port = args[1];
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConvertDialog.createAndShowGUI();
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        if (e.getSource() == this.chooseDirButton && (returnVal = this.fc.showOpenDialog(this)) == 0) {
            File file = this.fc.getSelectedFile();
            this.dirNameTextField.setText(file.getAbsolutePath());
        }
        if (e.getSource() == this.runButton) {
            ArrayList myList = new ArrayList();
            for (int i = 0; i < this.checkBoxes.length; ++i) {
                if (!this.checkBoxes[i].isSelected()) continue;
                myList.addAll(this.checkBoxes[i].getExtension());
            }
            Object[] ext = myList.toArray();
            MyFilter myFilter = new MyFilter(ext);
            System.out.println("should i include subdir=" + this.subDirCheckBox.isSelected());
            List fileList = this.findFilesFrom(this.dirNameTextField.getText(), myFilter, this.subDirCheckBox.isSelected());
            System.out.println("this is the number of files i have=" + fileList.size());
            DocConverter fc = new DocConverter("socket,host=" + host + ",port=" + port);
            try {
                fc.useConnection();
                Iterator it = fileList.iterator();
                while (it.hasNext()) {
                    File nextFile = (File)it.next();
                    String filePath = nextFile.getAbsolutePath();
                    this.convertFile(fc, filePath);
                    System.out.println(filePath);
                }
                fc.release();
            }
            catch (Exception exc) {
                System.out.println("OOOOOOOOOOps");
                exc.printStackTrace();
            }
        }
    }

    public List findFilesFrom(String dir, FilenameFilter filter, boolean recurse) {
        System.out.println("this is the dir=" + dir);
        this.filter = filter;
        ArrayList files = new ArrayList();
        this.scanDirectory(new File(dir), files, recurse);
        return files;
    }

    private void scanDirectory(File dir, List list, boolean recurse) {
        String[] candidates = dir.list(this.filter);
        for (int i = 0; i < candidates.length; ++i) {
            File tmp = new File(dir + FILE_SEP + candidates[i]);
            if (tmp.isDirectory()) {
                if (!recurse) continue;
                this.scanDirectory(tmp, list, true);
                continue;
            }
            list.add(new File(dir + FILE_SEP + candidates[i]));
        }
    }

    private void convertFile(DocConverter fc, String fullPath) throws Exception {
        Object toBeStored = fc.loadDocument(fullPath);
        XStorable xstorable = fc.getStorable(toBeStored);
        String exten = fullPath.substring(fullPath.lastIndexOf(".") + 1).toLowerCase();
        String conv = null;
        if (this.word.contains(exten)) {
            conv = "writer_pdf_Export";
        } else if (this.excel.contains(exten)) {
            conv = "calc_pdf_Export";
        } else if (this.powerPoint.contains(exten)) {
            conv = "impress_pdf_Export";
        } else if (this.images.contains(exten)) {
            conv = "draw_pdf_Export";
        }
        if (conv != null) {
            fc.saveDoc(xstorable, conv, "pdf");
        } else {
            System.out.println("not sure what happened here");
        }
    }
}

