#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include <apr.h>
#include <apr_pools.h>
#include <apr_strings.h>
#include <apr_time.h>
#include <apr_dbd.h>

#define NARGS 21

int main(int argc,char **argv){
  apr_pool_t *pool;
  const char *drivers[][2] = {{"pgsql","dbname=test"},
                              {"mysql","dbname=test"},
                              {"sqlite2","./test2.db"},
                              {"sqlite3","./test3.db"},
                              {NULL,NULL}};
  size_t i,j;
  int nrows;
  const apr_dbd_driver_t *driver;
  apr_dbd_t *sql;
  apr_dbd_prepared_t *stmt=NULL;
  apr_status_t rv;
  char d_tiny;
  unsigned char d_utiny;
  short d_short;
  unsigned short d_ushort;
  int d_int;
  unsigned int d_uint;
  long d_long;
  unsigned long d_ulong;
  apr_int64_t d_longlong;
  apr_uint64_t d_ulonglong;
  float d_float;
  double d_double;
  char *d_string,*d_text,*d_time,*d_date,*d_datetime,*d_timestamp,*d_ztimestamp;
  apr_dbd_blob_t d_blob;
  const char *args[NARGS];
  const void *vargs[NARGS];

  apr_initialize();
  apr_pool_create(&pool,NULL);

  apr_dbd_init(pool);

  for(i=0;drivers[i][0];i++){
    rv=apr_dbd_get_driver(pool,drivers[i][0],&driver);
    if(rv == APR_SUCCESS){
      rv=apr_dbd_open(driver,pool,drivers[i][1],&sql);
      if(rv == APR_SUCCESS){
        printf("driver[%u]: name=%s, conn=%s, loaded=%p\n",i,drivers[i][0],
                                                           drivers[i][1],sql);
        rv = apr_dbd_query(driver,sql,&nrows,"delete from test");
        if(rv != APR_SUCCESS)
          continue;

        printf("table cleared, rows affected=%d\n",nrows);

        rv = apr_dbd_prepare(driver,pool,sql,
                             "insert into test values("
                             "%hhd, %hhu, %hd, %hu, %d, %u, %ld, %lu, "
                             "%lld, %llu, %f, %lf, %s, "
                             "%pDt, %pDi, %pDd, %pDa, %pDs, %pDz, %pDb, %pDn)",
                             "apu_dbd_insert",
                             &stmt);
        if(rv != APR_SUCCESS)
          continue;

        printf("prepared statement=%p\n",stmt);

        d_tiny=-1;
        d_utiny=1;
        d_short=-2;
        d_ushort=2;
        d_int=-3;
        d_uint=3;
        d_long=-4;
        d_ulong=4;
        d_longlong=-5;
        d_ulonglong=5;
        d_float=6;
        d_double=7;
        d_string="string";
        d_text="text";
        d_time="11:22";
        d_date="2006-08-29";
        d_datetime="2006-08-29 11:22";
        d_timestamp="2006-08-29 11:22";
        d_ztimestamp="2006-08-29 11:22";
        d_blob.data="blob";
        d_blob.size=strlen(d_blob.data);
        d_blob.table=NULL;
        d_blob.column=NULL;

        args[0]=apr_psprintf(pool,"%hd",d_tiny);
        args[1]=apr_psprintf(pool,"%hu",d_utiny);
        args[2]=apr_psprintf(pool,"%hd",d_short);
        args[3]=apr_psprintf(pool,"%hu",d_ushort);
        args[4]=apr_psprintf(pool,"%d",d_int);
        args[5]=apr_psprintf(pool,"%u",d_uint);
        args[6]=apr_psprintf(pool,"%ld",d_long);
        args[7]=apr_psprintf(pool,"%lu",d_ulong);
        args[8]=apr_psprintf(pool,"%" APR_INT64_T_FMT,d_longlong);
        args[9]=apr_psprintf(pool,"%" APR_UINT64_T_FMT,d_ulonglong);
        args[10]=apr_psprintf(pool,"%f",d_float);
        args[11]=apr_psprintf(pool,"%lf",d_double);
        args[12]=d_string;
        args[13]=d_text;
        args[14]=d_time;
        args[15]=d_date;
        args[16]=d_datetime;
        args[17]=d_timestamp;
        args[18]=d_ztimestamp;
        args[19]=apr_psprintf(pool,"%" APR_SIZE_T_FMT ":::%s",
                              d_blob.size,d_blob.data);
        args[20]=NULL;

        for(j=0;j<NARGS;j++)
          printf("args[%u]=%s\n",j,args[j]);

        rv = apr_dbd_pquery(driver,pool,sql,&nrows,stmt,NARGS,args);
        if(rv != APR_SUCCESS)
          continue;

        printf("query status=%d\n",rv);

        vargs[0]=&d_tiny;
        vargs[1]=&d_utiny;
        vargs[2]=&d_short;
        vargs[3]=&d_ushort;
        vargs[4]=&d_int;
        vargs[5]=&d_uint;
        vargs[6]=&d_long;
        vargs[7]=&d_ulong;
        vargs[8]=&d_longlong;
        vargs[9]=&d_ulonglong;
        vargs[10]=&d_float;
        vargs[11]=&d_double;
        vargs[12]=d_string;
        vargs[13]=d_text;
        vargs[14]=d_time;
        vargs[15]=d_date;
        vargs[16]=d_datetime;
        vargs[17]=d_timestamp;
        vargs[18]=d_ztimestamp;
        vargs[19]=&d_blob;
        vargs[20]=NULL;

        rv = apr_dbd_pbquery(driver,pool,sql,&nrows,stmt,NARGS,vargs);
        if(rv != APR_SUCCESS)
          continue;

        printf("query status=%d\n",rv);
      }
    }
  }

  apr_terminate();
  return 0;
}
