/*
 *   @(#) $Id$
 *
 *   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

package org.apache.mina.examples.bug;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Logger;

import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.SerializationFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketSession;

/**
 * Test client implementation using the serialization filter.
 * <ol>
 * <li> Client connect to server </li>
 * <li> Sends a {@link Message} </li>
 * <li> Receives a {@link Message} response</li>
 * </ol>
 * 
 * @author Matteo Merli (matteo.merli@gmail.com)
 * @version $Rev$
 */
public class Client extends IoHandlerAdapter
{

	private static final Logger log = Logger.getLogger( Client.class.getName() );

	private static SerializationFilter serializationFilter = new SerializationFilter();

	public static void main( String[] args ) throws Exception
	{
		// Simple test: send a Message object to server.
		// Connect to the server.

		SocketConnector connector = new SocketConnector();
		SocketAddress address = new InetSocketAddress( "localhost", Server.PORT );
		ConnectFuture future = connector.connect( address, new Client() );
		future.join();
		log.info( "connected to " + address );
		IoSession session = future.getSession();
// Lower the size of the byte array and the client sends this message
		byte[] dr = new byte[100];
		for(int i=0;i<dr.length;i++){
			dr[i]=1;
		}
		
		System.out.println("Before Sending Message:");
		// Send a message
		Message message = new Message( 1, "Client->Server", dr );
		session.write( message );
		System.out.println("After Sending Message: Look in the server console for message.");
		// wait a little bit for the reply
		while ( session.isConnected() ) {
			Thread.sleep( 10000 );
		}
		System.out.println("Waited enough for a message from the Server:");
		// Clear the filter chain so that they are deinitialized.
		connector.getFilterChain().clear();
	}

	public void sessionCreated( IoSession session ) throws Exception
	{
		
		/*
		if( session instanceof SocketSession )
        {
            ( ( SocketSession ) session ).setSessionReceiveBufferSize( 480*1000 );
            ( ( SocketSession ) session ).setSendBufferSize( 480*1000 );
        }
        */
		session.getFilterChain().addLast( "serialization", serializationFilter );
		log.info( "added serialization filter." );
	}

	public void messageReceived( IoSession session, Object object ) throws Exception
	{
		Message message = (Message) object;
		log.info( "Received from server: " + message );
		
		// we only want to receive a single message
		session.close();
	}

}
