package nlog4jtest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.apache.log4j.Category;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.PropertyConfigurator;

/**
 * Test issues observed under extreme log where messages for category appear in wrong appender / are truncated etc.
 *
 * @version $Rev$
 */
public class NLog4jTest
{
    private static final Logger log = LoggerFactory.getLogger( NLog4jTest.class );
    private static final Logger loggerStub = LoggerFactory.getLogger("nlog4jtest.loggerStub");

    private static int          i;

    private static synchronized int getI()
    {
        return i++;
    }

    private static void createAppender(final String loggerName)
    {
        Category                        cat;
        final String                    fileName;
        final DailyRollingFileAppender  dailyAppender;
        final Logger                    logger;
        final DailyRollingFileAppender  cpDdailyAppender;

        try
        {
            cat = (Category)loggerStub;
            dailyAppender = ((DailyRollingFileAppender)cat.getAppender("cloneAppender"));
            fileName = dailyAppender.getFile().replaceFirst("LOGGERNAME", loggerName);
            log.info("logger '" + loggerName + "' logging to file connName '" + fileName + "'");
            logger = LoggerFactory.getLogger(loggerName);
            cat = (Category)logger;
            cat.setAdditivity(false);

                // note: underlying file is opened for "append", not "truncate" ...
            cpDdailyAppender = new DailyRollingFileAppender(dailyAppender.getLayout(),
                    fileName, dailyAppender.getDatePattern());
            cpDdailyAppender.setName(loggerName);
            // need to copy the encoding as well
            if (dailyAppender.getEncoding() != null)
            {
                cpDdailyAppender.setEncoding(dailyAppender.getEncoding());
                cpDdailyAppender.activateOptions();
            }
            cat.addAppender(cpDdailyAppender);
        }
        catch (Throwable e)
        {
            log.error("failed getting logger for '" + loggerName + '\'', e);
        }
    }

    private static class LogThread extends Thread
    {
        private final String    tlogName = "nlog4jtest.LogThread." + getI();
        private final Logger    tlog = LoggerFactory.getLogger( tlogName );
        private final int       delayMillis;

        public LogThread(int delayMillis)
        {
            createAppender(tlogName);
            this.delayMillis = delayMillis;
        }

        public void run()
        {
            for (int i = 0; i < 100; i++)
            {
                tlog.debug("message: " + tlogName + ":" + i);
                try
                {
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException e)
                {
                    e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
                }
            }
        }
    }

    public static void main(String[] args)
    {
        int         nlthreads = Integer.parseInt(args[0]);
        int         delayMillis = Integer.parseInt(args[1]);
        Thread[]    lthreads = new Thread[nlthreads];


        PropertyConfigurator.configure("nlog4jtest.properties");
        log.debug("starting " + lthreads.length + " threads");
        for (int i = 0; i < lthreads.length; i++)
        {
            lthreads[i] = new LogThread(delayMillis);
            lthreads[i].start();
        }
        log.debug("finished " + lthreads.length + " threads");
    }
}
