import com.gemstone.gemfire.cache.Cache;

import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.operations.GetOperationContext;

import com.gemstone.gemfire.distributed.DistributedMember;

import com.gemstone.gemfire.security.AccessControl;
import com.gemstone.gemfire.security.NotAuthorizedException;

import java.security.Principal;

public class PrePostGetOperationAccessControl implements AccessControl {
  
  private Cache cache;

  public static AccessControl create() {
    return new PrePostGetOperationAccessControl();
  }

  public void init(Principal principal, DistributedMember remoteMember, Cache cache) throws NotAuthorizedException {
    this.cache = cache;
  }

  public boolean authorizeOperation(String regionName, OperationContext context) {
    if (context.getOperationCode().isGet()) {
      GetOperationContext goc = (GetOperationContext) context;
      if (goc.isPostOperation()) {
        afterGet(goc);
      } else {
        beforeGet(goc);
      }
    }
    return true;
  }

  private void beforeGet(GetOperationContext goc) {
    this.cache.getLogger().info("PrePostGetOperationAccessControl beforeGet key=" + goc.getKey());
  }

  private void afterGet(GetOperationContext goc) {
    this.cache.getLogger().info("PrePostGetOperationAccessControl afterGet key=" + goc.getKey() + "; value=" + goc.getDeserializedValue());
  }
  
  public void close() {}
}
