import com.gemstone.gemfire.cache.client.ClientCacheFactory;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;

import java.util.Random;

public class TestClient {

  private GemFireCache cache;
  
  private Region region;

  public static void main(String[] args) throws Exception {
    TestClient client = new TestClient();

    // Initialize the cache
    client.initializeClientCache();

    // Retrieve the regions
    client.initializeRegion("data");
    
    String operation = args[0];
    int numEntries = Integer.parseInt(args[1]);
    if (operation.equals("load")) {
      client.loadEntries(numEntries);
    } else if (operation.equals("get")) {
      client.getEntries(numEntries);
    } else if (operation.equals("get-forever")) {
      client.getEntriesForever(numEntries);
    }
  }

  private void initializeRegion(String regionName) {
    this.region = this.cache.getRegion(regionName);
    System.out.println("Retrieved region: " + this.region);
  }
  
  private void initializeClientCache() {
    this.cache = new ClientCacheFactory().create();
    System.out.println("Created " + this.cache);
  }

  protected void loadEntries(int numEntries) throws Exception {
    long start=0, end=0;
    start = System.currentTimeMillis();
    for (int i=0; i<numEntries; i++) {
      this.region.put(getKey(i), "value-"+i);
    }
    end = System.currentTimeMillis();
    System.out.println("Loaded " + numEntries + " entries in " + (end-start) + " ms");
  }

  private void getEntries(int numEntries) throws Exception {
    long start=0, end=0;
    start = System.currentTimeMillis();
    for (int i=0; i<numEntries; i++) {
      System.out.println("Retrieved [" + i + "]: " + this.region.get(getKey(i)));
    }
    end = System.currentTimeMillis();
    System.out.println("Retrieved " + numEntries + " entries in " + (end-start) + " ms");
  }

  private void getEntriesForever(int numEntries) throws Exception {
    Random rand = new Random();
    while (true) {
      int i = rand.nextInt(numEntries);
      System.out.println("Retrieved [" + i + "]: " + this.region.get(i));
    }
  }
  
  private Object getKey(int index) {
    return "key-"+index;
  }
}