package testbundle;

import java.util.*;

import org.osgi.framework.*;
import org.osgi.service.condpermadmin.*;
import org.osgi.service.permissionadmin.*;

public class Activator extends Thread implements BundleActivator {

	private BundleContext bc;
	private PermissionAdmin permAdmin = null;
	private ConditionalPermissionAdmin condPermAdmin = null;

	public static ConditionInfo EMPTY_COND_ARRAY[] = new ConditionInfo[0];
	public static PermissionInfo EMPTY_PERM_ARRAY[] = new PermissionInfo[0];

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext
	 * )
	 */
	public void start(BundleContext context) throws Exception {
		ServiceReference ref;

		System.out.println("[TEST] In TestBundle Activator");
		this.bc = context;

		ref = bc.getServiceReference(ConditionalPermissionAdmin.class.getName());
		if (ref != null) {
			condPermAdmin = (ConditionalPermissionAdmin) bc.getService(ref);
		}
		ref = bc.getServiceReference(PermissionAdmin.class.getName());
		if (ref != null) {
			permAdmin = (PermissionAdmin) bc.getService(ref);
		}
		System.out.println("[TEST] condPermAdmin="+condPermAdmin + " permAdmin="+permAdmin);

		System.out.println("[TEST] Starting separate thread");
		this.start();
	}

	public void run() {
		System.out.println("[TEST] In Thread.run()");

		try {
			System.out.println("[TEST] Setting non-conditional no permissions");	
			condPermAdmin.setConditionalPermissionInfo( null, EMPTY_COND_ARRAY, EMPTY_PERM_ARRAY);
			System.out.println("[TEST] Exited setConditionalPermissionInfo");	
			System.out.println();
			System.out.println("[TEST] Retrieving SecurityManager");	
			SecurityManager sm = System.getSecurityManager();
			System.out.println("[TEST] Checking PropertyPermission");	
			sm.checkPermission( new PropertyPermission("java.vendor", "write"));
			System.out.println("[TEST] Exited Permission check with no SecurityException");
			System.out.println();
/*
			System.out.println("[TEST] Calling setProperty");
			System.setProperty( "java.vendor", "Guillaume");

			System.out.println("[TEST] Calling getProperty");	
			String vendor = System.getProperty( "java.vendor");
			System.out.println("[TEST] java.vendor=" + vendor);
*/
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	}

}
