%define DISTRO %([ -f /etc/redhat-release ] && sed -e "s/\\(.\\+\\)\\( Linux release \\)\\(.\\+\\)\\( .\\+\\)/\\1 \\3/" /etc/redhat-release)
%define DISTRO_REL %([ -f /etc/redhat-release ] && sed -e "s/\\(.\\+ release \\)\\(.\\+\\)\\( .\\+\\)/\\2/" /etc/redhat-release)
%define REQ_RPM_REL %(rpm -q --queryformat "%{VERSION}" rpm)
%define GLIBC_REL %(rpm -q --queryformat "%{VERSION}" glibc)

%define contentdir 	%{_var}/www2
%define logdir     	%{_var}/log/%{pname}
%define confdir    	%{_sysconfdir}/%{pname}/conf
%define lport 	   	8092
%define ssllport 	8093
%define pname	 	httpd2
%define	apreleasen	42
%define	apversion	2.0
%define ap2uid     	92
%define aprrel    	0.9.2

Summary: 	Latest Apache HTTP daemon
Name: 		apache2
Version: 	%{apversion}.%{apreleasen}
Release: 	1.%{DISTRO_REL}
License:        Apache Software License
Vendor:         Apache Software Foundation
Group: 		System Environment/Daemons
Source0: 	httpd://dev.apache.org/dist/httpd-2.0.%{apreleasen}.tar.gz
Source1:        cert-stuff.tar.gz
Source2: 	%{pname}.init
Source3: 	%{pname}.log
BuildRoot: 	/var/tmp/%{name}-%{apreleasen}-root
Requires: 	initscripts >= 3.25
Requires: 	openssl >= 0.9.6
BuildRequires:	openssl-devel >= 0.9.6
Prereq: 	/sbin/chkconfig
URL:            http://httpd.apache.org/
Packager:       Henri Gomez <hgomez@users.sourceforge.net>
Obsoletes:      apr

%description
Apache is a powerful, full-featured, efficient and freely-available
Web server. Apache is also the most popular Web server on the
Internet. Apache 2.0 is the new generation of Apache HTTP server
using many advanced features.


%package devel
Group: 		Development/Libraries
Summary: 	Module development tools for apache2

%description devel
The apache2-devel package contains header files and the
apxs script needed to build Dynamic Shared Objects (DSOs) for Apache.

If you are installing apache2, and want to be able
to compile or develop additional modules, you'll have to
install this package.


%package manual
Group: Documentation
Summary: Documentation for the Apache 2.0 Web server.

%description manual
The apache2-manual package contains the complete manual and reference
guide for the Apache Web server.  If you need Apache documentation
installed on the local machine, install this package.  The information
can also be found on the Web at http://httpd.apache.org/


%prep 
%setup -n httpd-2.0.%{apreleasen}

mv docs/conf/httpd-std.conf.in docs/conf/httpd-std.conf.in.bak

sed -e 's;@@ServerRoot@@/@rel_cgidir@;@rel_cgidir@;' \
    -e 's;@@ServerRoot@@/@rel_errordir@;@rel_errordir@;' \
    -e 's;@@ServerRoot@@/@rel_htdocsdir@;@rel_htdocsdir@;' \
    -e 's;@@ServerRoot@@/@rel_iconsdir@;@rel_iconsdir@;' \
    -e 's;@@ServerRoot@@/@rel_manualdir@;@rel_manualdir@;' \
    -e 's;@@ServerRoot@@/@rel_proxycachedir@;@rel_proxycachedir@;' \
    -e 's;@rel_runtimedir@/httpd.pid;@rel_runtimedir@/httpd2.pid;' \
    -e 's;User nobody;User %{name};' \
    -e 's;Group #-1;Group %{name};' \
    docs/conf/httpd-std.conf.in.bak > docs/conf/httpd-std.conf.in

mv docs/conf/ssl-std.conf docs/conf/ssl-std.conf.bak

sed -e 's;443;%{ssllport};' \
    -e 's;<IfDefine SSL>;<IfDefine HAVE_SSL>;' \
    -e 's;ServerName;##ServerName;' \
    -e 's;@@ServerRoot@@/htdocs;%{contentdir}/html;' \
    -e 's;logs/ssl_scache;%{_var}/run/ssl_scache2;' \
    -e 's;logs/;%{logdir}/;' \
    -e 's;@@ServerRoot@@/conf;%{confdir};' \
    docs/conf/ssl-std.conf.bak > docs/conf/ssl-std.conf 

%build
cat >> config.layout <<EOF
#   RedHat 7.x layout to coexist with Apache 1.3
<Layout RedHat7C>
	prefix:        %{_sysconfdir}/%{pname}
	exec_prefix:   %{_prefix}
	bindir:        %{_bindir}
	sbindir:       %{_sbindir}
	libexecdir:    %{_libdir}/%{name}
	mandir:        %{_mandir}
	sysconfdir:    %{confdir}
	datadir:       %{contentdir}
	iconsdir:      %{contentdir}/icons
	htdocsdir:     %{contentdir}/html
    	installbuilddir: %{_sysconfdir}/%{pname}/build
	errordir:      %{contentdir}/error
	manualdir:     %{contentdir}/manual
	cgidir:        %{contentdir}/cgi-bin
	includedir:    %{_includedir}/%{name}
	localstatedir: %{_localstatedir}
	runtimedir:    %{_var}/run
	logfiledir:    %{logdir}
	proxycachedir: %{_var}/cache/%{pname}
</Layout>

EOF

CFLAGS="$RPM_OPT_FLAGS" ./configure \
	--with-program-name=%{pname} \
	--with-port=8092 \
	--with-mpm=worker \
	--prefix=%{_sysconfdir}/%{pname} \
	--exec-prefix=%{_prefix} \
	--bindir=%{_sbindir} \
	--sbindir=%{_sbindir} \
	--libexecdir=%{_libdir}/%{name} \
	--mandir=%{_mandir} \
	--localstatedir=%{_localstatedir} \
	--sysconfdir=%{_sysconfdir}/%{pname}/conf \
	--datadir=%{contentdir} \
	--includedir=%{_includedir}/%{name} \
	--enable-layout=RedHat7C \
	--enable-modules=all \
	--enable-mods-shared=all \
	--enable-cgi \
	--enable-ssl \
	--enable-proxy \
	--enable-so \
	--with-ssl=/usr/include/

make

%install
[ "${RPM_BUILD_ROOT}" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

make install prefix=%{_sysconfdir}/%{pname} bindir=${RPM_BUILD_ROOT}%{_sbindir} sbindir=${RPM_BUILD_ROOT}%{_sbindir} installbuilddir=${RPM_BUILD_ROOT}%{_sysconfdir}/%{pname}/build libdir=${RPM_BUILD_ROOT}%{_libdir} libexecdir=${RPM_BUILD_ROOT}%{_libdir}/%{name} mandir=${RPM_BUILD_ROOT}%{_mandir} sysconfdir=${RPM_BUILD_ROOT}%{_sysconfdir}/%{pname}/conf datadir=${RPM_BUILD_ROOT}%{contentdir} iconsdir=${RPM_BUILD_ROOT}%{contentdir}/icons errordir=${RPM_BUILD_ROOT}%{contentdir}/error htdocsdir=${RPM_BUILD_ROOT}%{contentdir}/html manualdir=${RPM_BUILD_ROOT}%{contentdir}/manual cgidir=${RPM_BUILD_ROOT}%{contentdir}/cgi-bin includedir=${RPM_BUILD_ROOT}%{_includedir}/%{name} localstatedir=${RPM_BUILD_ROOT}%{_localstatedir} runtimedir=${RPM_BUILD_ROOT}{%_var}/run logfiledir=${RPM_BUILD_ROOT}%{_var}/log/%{pname} proxycachedir=${RPM_BUILD_ROOT}%{_var}/cache/%{pname}

# Use HAVE_SSL instead of just SSL
perl -pi -e "s|<IfDefine SSL>|<IfDefine HAVE_SSL>|g;" ${RPM_BUILD_ROOT}%{confdir}/%{pname}.conf

# install apr & apr-utils

mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
cp srclib/apr/.libs/libapr.so.%{aprrel} ${RPM_BUILD_ROOT}%{_libdir}
cp srclib/apr-util/.libs/libaprutil.so.%{aprrel} ${RPM_BUILD_ROOT}%{_libdir}
cp srclib/apr/.libs/libapr.a ${RPM_BUILD_ROOT}%{_libdir}
cp srclib/apr-util/.libs/libaprutil.a ${RPM_BUILD_ROOT}%{_libdir}

# copy ssl.conf
cp docs/conf/ssl-std.conf ${RPM_BUILD_ROOT}%{confdir}/ssl.conf
# install snakeoil stuff
(cd ${RPM_BUILD_ROOT}%{confdir} && tar xvzf %{SOURCE1})

# patch modules/ to lib/apache2/
# perl -pi -e "s|modules/|lib/%{name}/|g;" ${RPM_BUILD_ROOT}%{confdir}/%{pname}.conf

# httpd2 allready set
for i in ab apxs apachectl logresolve rotatelogs; do
	mv ${RPM_BUILD_ROOT}%{_sbindir}/${i} ${RPM_BUILD_ROOT}%{_sbindir}/${i}2
done

# make symlink modules -> /usr/lib/apache2 and logs -> /var/log/httpd2
# follow Redhat 7.x spec file
(cd  ${RPM_BUILD_ROOT}%{_sysconfdir}/%{pname} && ln -s ../..%{_libdir}/%{name} modules)
(cd  ${RPM_BUILD_ROOT}%{_sysconfdir}/%{pname} && ln -s ../..%{_var}/log/%{pname} logs)

# bindir is not created by install
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}

for i in htdigest htpasswd; do
    mv ${RPM_BUILD_ROOT}%{_sbindir}/${i} ${RPM_BUILD_ROOT}%{_bindir}/${i}2
done

# ab.8  apachectl.8  apxs.8  dbmmanage.1  htdigest.1  htpasswd.1  httpd.8  logresolve.8  rotatelogs.8  suexec.8
# no suexec yet

# rename xxxx man pages to xxxx2 and install in rigth subdir 
for i in dbmmanage htdigest htpasswd; do
	mv ${RPM_BUILD_ROOT}%{_mandir}/man1/${i}.1 ${RPM_BUILD_ROOT}%{_mandir}/man1/${i}2.1
done

# no suexec yet
for i in ab apachectl apxs httpd logresolve rotatelogs; do
	mv ${RPM_BUILD_ROOT}%{_mandir}/man8/${i}.8 ${RPM_BUILD_ROOT}%{_mandir}/man8/${i}2.8
done

# the search script is not used
rm -rf ${RPM_BUILD_ROOT}/%{contentdir}/manual/search/

# sysv init and logging
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/{logrotate.d,rc.d/init.d}
install %{SOURCE2} ${RPM_BUILD_ROOT}%{_sysconfdir}/rc.d/init.d/%{pname}
install %{SOURCE3} ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d/%{pname}

# misc not created by install
mkdir -p ${RPM_BUILD_ROOT}%{_var}/cache/%{pname}
mkdir -p ${RPM_BUILD_ROOT}%{_var}/log/%{pname}

# remove unnecessary .la (DSO)
rm -f ${RPM_BUILD_ROOT}%{_libdir}/%{name}/*.la

# cleanup config_var.mk
perl -pi -e "s|${RPM_BUILD_ROOT}/|/|g" ${RPM_BUILD_ROOT}%{_sysconfdir}/%{pname}/build/config_vars.mk

%clean
rm -rf "${RPM_BUILD_ROOT}"

%pre
# Add the "apache2" user
# we need a shell to be able to use su - later
/usr/sbin/useradd -c "Apache2" -u %{ap2uid} \
    -s /bin/false -r -d %{contentdir} %{name} 2> /dev/null || :

%post
# apr & apr-utils
/sbin/ldconfig
# install httpd2 (but don't activate)
/sbin/chkconfig --add %{pname}

%preun
if [ $1 = 0 ]; then
    if [ -x /sbin/service ]; then
        /sbin/service %{pname} stop > /dev/null 2>&1
    else
	    if [ -f /var/lock/subsys/%{pname} ]; then
		    %{_sysconfdir}/rc.d/init.d/%{pname} stop
	    fi
    fi

    /sbin/chkconfig --del %{pname}
    /usr/sbin/userdel %{name}
fi


%files
%defattr(-,root,root)
%dir 				%{_sysconfdir}/%{pname}/conf
%dir 				%{_sysconfdir}/%{pname}/conf/ssl.crl
%dir 				%{_sysconfdir}/%{pname}/conf/ssl.crt
%dir 				%{_sysconfdir}/%{pname}/conf/ssl.csr
%dir 				%{_sysconfdir}/%{pname}/conf/ssl.key
%dir 				%{_sysconfdir}/%{pname}/conf/ssl.prm
%config(noreplace) 	%{_sysconfdir}/%{pname}/conf/%{pname}.conf
%config(noreplace) 	%{_sysconfdir}/%{pname}/conf/ssl.conf
%config 			%{_sysconfdir}/%{pname}/conf/magic
%config 			%{_sysconfdir}/%{pname}/conf/mime.types
%config             %{_sysconfdir}/%{pname}/conf/ssl.crl/*
%config             %{_sysconfdir}/%{pname}/conf/ssl.crt/*
%config             %{_sysconfdir}/%{pname}/conf/ssl.csr/*
%config             %{_sysconfdir}/%{pname}/conf/ssl.key/*
%config             %{_sysconfdir}/%{pname}/conf/ssl.prm/*

%{_sysconfdir}/%{pname}/modules
%{_sysconfdir}/%{pname}/logs

%{_sysconfdir}/%{pname}/conf/highperformance-std.conf
%{_sysconfdir}/%{pname}/conf/highperformance.conf
%{_sysconfdir}/%{pname}/conf/httpd-std.conf
%config 				%{_sysconfdir}/logrotate.d/%{pname}
%config 				%{_sysconfdir}/rc.d/init.d/%{pname}

%doc {ABOUT_APACHE,CHANGES,INSTALL,LICENSE,README}

%dir %{contentdir}
%dir %{contentdir}/cgi-bin
%{contentdir}/html
%{contentdir}/icons
%{contentdir}/error

%{_libdir}/*.so*
%{_libdir}/%{name}/*.so
%{_mandir}/man1/*
%{_mandir}/man8/ab*
%{_mandir}/man8/apachectl*
%{_mandir}/man8/httpd*
%{_mandir}/man8/logresolve*
%{_mandir}/man8/rotatelogs*
#%{_mandir}/man8/suexec*

%{_bindir}/htdigest2
%{_bindir}/htpasswd2
%{_sbindir}/ab2
%{_sbindir}/apachectl2
%{_sbindir}/%{pname}
%{_sbindir}/logresolve2
%{_sbindir}/rotatelogs2
#%{_sbindir}/suexec2

%dir %{_var}/cache/%{pname}
%dir %{_var}/log/%{pname}

%files devel
%defattr(-,root,root)
%{_sysconfdir}/%{pname}/build
%attr( - ,root,root)  		%{_includedir}/apache2
%attr( - ,root,root)  		%{_sbindir}/apxs2
%attr( - ,root,root)  		%{_sbindir}/envvars
%attr( - ,root,root)  		%{_mandir}/man8/apxs*
%attr( - ,root,root)            %{_libdir}/*.a

%files manual
%defattr(-,root,root)
%{contentdir}/manual

%changelog
* Wed Sep 25 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.42

* Mon Aug 19 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.40 

* Thu Jul 18 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.39 rpm release 4
- add cgi support --enable-cgi (Peter Bieringher)

* Wed Jul 17 2002 Henri Gomez <hgomez@users.sourceforge.net> 
- Apache 2.0.39 rpm release 3
- fix bug in make install (missing % in var/run) (Peter Bieringher)
- fix bug in perl replace script (rel_runtimedir) (Peter Bieringher) 

* Fri Jul 12 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.39 rpm release 2
- fix build problems when non root (Manoj Kasichainula)

* Wed Jun 19 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.39

* Mon Jun 03 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.36

* Fri May 03 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.35 rpm release 3
- Add Redhat release in release number
- built on Redhat %{DISTRO_REL}, with glibc %{GLIBC_REL}

* Wed Apr 10 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.35 rpm release 2
- correct bad libdir not installing in buildroot

* Mon Apr 08 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0.35
- listen port is still 8092, ssl listening on port 8093
- chkconfig add httpd2 but don't make it on by default (i hope)

* Tue Mar 12 2002 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 beta 32
- remove patch for apxs in sbindir and manual since they 
  are now included.
- added mod_proxy

* Tue Nov 22 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 beta 28 RPM release 2
- fix apxs2 and config_vars.mk
- build stuff installed in %{_sysconfdir}/%{pname}/build

* Tue Nov 22 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 27 RPM release 2
- fix apxs2 and config_vars.mk
- build stuff installed in %{_sysconfdir}/%{pname}/build

* Mon Nov 21 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 beta 28 RPM

* Fri Nov 16 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 27
- Apache 2.0 will run under apache2 user (%{ap2uid}) instead of 
  nobody to follow Redhat 7.x
- Document root is now located in %{contentdir} to follow Redhat 7.x
  way which install stuff in /var/www
- manual is now installed in %{contentdir}/manual instead of html/manual
- apr and apr-utils are installed in %{_libdir}
- WARNING - dummy CERT installed into confdir (from Apache-mod_ssl)
- default HTTP port is 8092, and HTTPS port is 8093
- added man pages
- added error dir %{contentdir}/error

* Tue Jul 24 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 21 
- built under Redhat 6.2 + updates and rpm 3.0.5

* Mon May 21 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 18 RPM release 1
- built under Redhat 6.2 + updates and rpm 3.0.5
- DAV is built statically (can't built it in DSO)

* Mon Mar 26 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 15 RPM release 1

* Mon Mar 12 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 14 RPM release 2
- grabbed latest .tar.gz from dev.apache.org

* Fri Mar 08 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 14

* Mon Feb 26 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 12
- updates of module names (log_config_module, *auth*) 

* Thu Feb 15 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Apache 2.0 alpha 11
- dexter renamed to perchild
- mod_proxy removed

* Tue Feb 13 2001 Henri Gomez <hgomez@users.sourceforge.net>
- mod_tls patch included ;-)

* Mon Feb 12 2001 Henri Gomez <hgomez@users.sourceforge.net>
- added mod_tls
- now include/ap_config_auto.h is used instead of include/ap_config_path.h 

* Fri Feb 09 2001 Henri Gomez <hgomez@users.sourceforge.net>
- CVS grab 2001/02/09 06:00 CET
- include apxs patch

* Thu Feb 08 2001 Henri Gomez <hgomez@users.sourceforge.net>
- CVS grab 2001/02/08 11:00 CET

* Mon Feb 05 2001 Henri Gomez <hgomez@users.sourceforge.net>
- CVS grab 2001/02/05 13:00 CET 

* Thu Feb 01 2001 Henri Gomez <hgomez@users.sourceforge.net>
- apache 2.0 from cvs 2001/02/01
- nearly all modules in shared mode (modified httpd2.conf)
- built under Redhat 6.2 + updates + rpm 3.0.5

* Sat Jan 27 2001 Henri Gomez <hgomez@users.sourceforge.net>
- Initial RPM for apache 2.0 from cvs 2001/01/27
- all command are postfixed with 2: 
  ab2, apachectl2, httpd2, logresolve2, rotatelogs2, apxs2 
- some modules are not here since compilation failed :
  charset_lite, cache, disk-cache, eneric-hook-export, generic-hook-import, rewrite
- some adaptation to help build on RH7.0
- listen port is 8092 instead of 80
