use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

plan tests => 8, have_lwp;

{
    my $response = GET '/notfound.html';
    chomp(my $content = $response->content);

    ok t_cmp(404,
             $response->code,
             'notfound.html code');

    ok t_cmp(qr'per-server 404',
             $content,
             'notfound.html content');
}

{
    my $response = GET '/inherit/notfound.html';
    chomp(my $content = $response->content);

    ok t_cmp(404,
             $response->code,
             '/inherit/notfound.html code');

    ok t_cmp(qr'per-server 404',
             $content,
             '/inherit/notfound.html content');
}

{
    my $response = GET '/redefine/notfound.html';
    chomp(my $content = $response->content);

    ok t_cmp(404,
             $response->code,
             '/redefine/notfound.html code');

    ok t_cmp('per-dir 404',
             $content,
             '/redefine/notfound.html content');
}

{
    my $response = GET '/restore/notfound.html';
    chomp(my $content = $response->content);

    ok t_cmp(404,
             $response->code,
             '/redefine/notfound.html code');

    ok t_cmp(qr!Not Found!,
             $content,
             '/redefine/notfound.html content');
}
