use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;
use Apache::TestConfig ();

plan tests => 5, need_min_apache_version('2.0.0');

ok 1;

my $r = GET("/apache/block_links/");
ok t_cmp($r->code, 403, "calling url of a directory, where symlinks are not allowed and index.html is a symbolic link.");

$r = GET("/apache/block_links/index.html");
ok t_cmp($r->code, 403, "calling the url of a symlink 'index.html' in a dir where symlinks are not allowed");

$r = GET("/apache/allow_links/");
ok t_cmp($r->code, 200, "calling url of a directory, where symlinks are allowed and index.html is a symbolic link.");

$r = GET("/apache/allow_links/index.html");
ok t_cmp($r->code, 200, "calling url of a symlink 'index.html' in a dir where symlinks are allowed.");
