use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

plan tests => 6, have_module qw(mod_negotiation mod_mime);

## Returns ok if the returned content-type value is the same as the 
## expected one.
#
sub check_content_type  
{
    my $path = shift;
    my $expected = shift;
    my $error_msg = shift;

    my $h = HEAD_STR $path;

    ## parse response headers looking for our headers
    my $actual_value;
    foreach my $head (split /\n/, $h) {
	if ($head =~ /^Content-Type: (.*)$/) {
	    $actual_value = $1;
	    last;
	}
    }

    ok t_cmp($actual_value, $expected, $error_msg);
	
}

## The server is configured to return text/html; charset=iso8859-1 by default
## The different section overrides change this to charset=bogus. 
## We do the test with and without content-negotiation

my $expected_type = "text/html; charset=bogus";

check_content_type ("/apache/subrequests/dir_override/hello.html.bc", 
		    $expected_type,
		    "subrequests with <Directory> overrides");
check_content_type ("/apache/subrequests/dir_override/hello", 
		    $expected_type,
		    "subrequests with <Directory> overrides and conn-neg");

check_content_type ("/apache/subrequests/location_override/hello.html.bc",
		    $expected_type,
		    "subrequests with <Location> overrides");
check_content_type ("/apache/subrequests/location_override/hello",
		    $expected_type,
		    "subrequests with <Location> overrides and conn-neg");

check_content_type ("/apache/subrequests/htaccess_override/hello.html.bc",
		    $expected_type,
		    "subrequests with .htaccess overrides");
check_content_type ("/apache/subrequests/htaccess_override/hello",
		    $expected_type,
		    "subrequests with .htaccess overrides and conn-neg");
