<?php

class mobile extends rcube_plugin {
  function init() {
    $rcmail = rcube::get_instance();

    // deal with the problem of iframes in normal mode being so thing they trigger the responsive css
    if (strpos($_SERVER['REQUEST_URI'],'_framed=1') == false) {
      $this->include_stylesheet("mobile.css");
    } else {
      // mobile doesn't request things in frames, so sent a stylesheet with all mobile hidden
      $this->include_stylesheet("mobile-iframe.css");
    }

    if (method_exists($rcmail->output,'include_script')) {
      $rcmail->output->include_script('../../plugins/mobile/mobile.js');
    }
    $rcmail->output->set_env('infinitescroll',$rcmail->config->get('mail_infinitescroll'));
    if ($rcmail->task == 'addressbook') {
      // need pagesize set so addressbook pager behaves properly
      $rcmail->output->set_env('pagesize',$rcmail->config->get('mail_pagesize'));
    }
    $this->register_task('mobile');
    $this->register_action('index', array($this, 'index'));
    $this->add_hook('render_page',array($this, 'render_page'));
    $this->add_hook('template_container',array($this, 'template_container'));
    $this->add_hook('config_get',array($this,'config_get'));
  }

function template_container($args) {
rcube::write_log('get_user_key',"template_container=".$args['name']);
}

  function config_get($args) {
    if ($args['name'] == 'htmleditor') {
      if ($_COOKIE['rcube_mobile'] && $_COOKIE['rcube_mobile'] == 1) {
        // mobile cookie set, force htmleditor to be off
        $args['result'] = 0;
      }
    }
    return($args);
  }

  function render_page($args) {
    // add in a span we can use to check if we are in mobile view cia with the isMobile() function
    $args['content'] .= "<span id='mobilecheck'></span>\n";
    return($args);
  }

  function index() {
    // this is called for the mini settings page
    $rcmail = rcube::get_instance();

    // get timezones
    $tz_available = array();
    $tz_text = file_get_contents('/mail/postboot/etc/timezones.cfg');
    $tz_lines = explode("\n",$tz_text);
    foreach ($tz_lines as $tz_line) {
      if (substr($tz_line,1) !== "#") {
        $tz_linedata = explode("=",$tz_line,2);
        $tz_available[$tz_linedata[0]] = $tz_linedata[1];
      }
    }
    $zones = array();
    foreach (DateTimeZone::listIdentifiers() as $i => $tzs) {
      try {
        $tz      = new DateTimeZone($tzs);
        if (!array_key_exists($tzs,$tz_available)) { continue; }
        $date    = new DateTime('2012-12-21', $tz);
        $offset  = $date->format('Z') + 45000;
        $sortkey = sprintf('%06d.%s', $offset, $tzs);
        $zones[$sortkey] = array($tzs, $date->format('P'));
      }
      catch (Exception $e) {}
    }
    ksort($zones);
    $truezones = array();
    foreach ($zones as $obj) {
      list($tzs, $offset) = $obj;
      if ($tz_available[$tzs]) {
        $truezones[$tzs] = $tz_available[$tzs];
      }
    }
    $rcmail->output->set_env('timezones',$truezones);
    $timezone = $rcmail->config->get('timezone');
    $rcmail->output->set_env('timezone',$timezone);

    // get languages
    $a_lang = $rcmail->list_languages();
    ksort($a_lang);
    $rcmail->output->set_env('languages',$a_lang);
    $lang = $rcmail->get_user_language();
    $rcmail->output->set_env('language',$rcmail->get_user_language());

    // other prefs
    $rcmail->output->set_env('mail_pagesize',$rcmail->config->get('mail_pagesize'));
    $rcmail->output->set_env('prefer_html',$rcmail->config->get('prefer_html'));
    $rcmail->output->set_env('show_images',$rcmail->config->get('show_images'));
    
    $rcmail->output->send('mobile.settings');
  }
}

?>
