package breakpluginpluginj8.brokenplugin;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * Breaks because of lambda expression, see below:
 */
@Mojo(name = "break", defaultPhase = LifecyclePhase.TEST)

public class MojoWithMethodRefLambda extends AbstractMojo {

	// THE CULPRIT:
	// if commented out the maven plugin plugin won't fail
	// (it uses a Java 8 method reference to create the comparator)
	Comparator<Integer> mycomp = MojoWithMethodRefLambda::compareInts;
			
	@Parameter(defaultValue = "${project.compileClasspathElements}")
	private String[] classpathElements;

	static int compareInts(Integer i, Integer j) {
		// not relevant for our test
		return 0;
	}
	
	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		getLog().info( "classpath elements given: " + Arrays.asList(classpathElements).toString() );
	}
}
