/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.loader;

import com.sun.star.lib.loader.WinRegKey;
import com.sun.star.lib.loader.WinRegKeyException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

final class InstallationFinder {
    private static final String SYSPROP_NAME = "com.sun.star.lib.loader.unopath";
    private static final String ENVVAR_NAME = "UNO_PATH";
    private static final String SOFFICE = "soffice";

    private InstallationFinder() {
    }

    public static String getPath() {
        String string = null;
        string = InstallationFinder.getPathFromProperty(SYSPROP_NAME);
        if (string == null && (string = InstallationFinder.getPathFromEnvVar(ENVVAR_NAME)) == null) {
            String string2 = null;
            try {
                string2 = System.getProperty("os.name");
            }
            catch (SecurityException securityException) {
                return null;
            }
            if (string2 != null) {
                if (string2.startsWith("Windows")) {
                    string = InstallationFinder.getPathFromWindowsRegistry();
                } else {
                    string = InstallationFinder.getPathFromPathEnvVar();
                    if (string == null && (string = InstallationFinder.getPathFromWhich()) == null) {
                        string = InstallationFinder.getPathFromSVersionFile();
                    }
                }
            }
        }
        return string;
    }

    private static String getPathFromProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2;
    }

    private static String getPathFromEnvVar(String string) {
        String string2 = null;
        try {
            string2 = System.getenv(string);
        }
        catch (SecurityException securityException) {
        }
        catch (Error error) {
            // empty catch block
        }
        return string2;
    }

    private static String getPathFromWindowsRegistry() {
        String string = null;
        try {
            WinRegKey winRegKey = new WinRegKey("HKEY_CURRENT_USER", "Software\\OpenOffice.org\\UNO\\InstallPath");
            string = winRegKey.getStringValue("");
        }
        catch (WinRegKeyException winRegKeyException) {
            try {
                WinRegKey winRegKey = new WinRegKey("HKEY_LOCAL_MACHINE", "Software\\OpenOffice.org\\UNO\\InstallPath");
                string = winRegKey.getStringValue("");
            }
            catch (WinRegKeyException winRegKeyException2) {
                System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWindowsRegistry: reading key from Windows Registry failed: " + winRegKeyException2);
            }
        }
        return string;
    }

    private static String getPathFromPathEnvVar() {
        String string = null;
        String string2 = null;
        try {
            string2 = System.getenv("PATH");
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken(), SOFFICE);
                try {
                    if (!file.exists()) continue;
                    try {
                        string = file.getCanonicalFile().getParent();
                        if (string == null) continue;
                        break;
                    }
                    catch (IOException iOException) {
                        System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromEnvVar: bad path: " + iOException);
                    }
                }
                catch (SecurityException securityException) {}
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPathFromWhich() {
        var1 = null;
        var2_1 = new String[]{"which", "soffice"};
        var3_2 = null;
        var4_3 = Runtime.getRuntime();
        try {
            var3_2 = var4_3.exec(var2_1);
        }
        catch (SecurityException var5_4) {
            return null;
        }
        catch (IOException var5_5) {
            System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWhich: which command failed: " + var5_5);
            return null;
        }
        var5_6 = new StreamGobbler(var3_2.getErrorStream());
        var5_6.start();
        var6_7 = new BufferedReader(new InputStreamReader(var3_2.getInputStream()));
        var7_8 = null;
        try {
            try {}
            catch (IOException var8_10) {
                System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWhich: reading which command output failed: " + var8_10);
                var9_13 = null;
                var15_20 = null;
                if (var6_7 == null) return var9_13;
                try {
                    var6_7.close();
                    return var9_13;
                }
                catch (IOException var16_24) {
                    // empty catch block
                }
                return var9_13;
            }
        }
        catch (Throwable var14_26) {
            var15_21 = null;
            if (var6_7 == null) throw var14_26;
            ** try [egrp 4[TRYBLOCK] [9 : 279->287)] { 
lbl37:
            // 1 sources

            var6_7.close();
            throw var14_26;
lbl39:
            // 1 sources

            catch (IOException var16_25) {
                // empty catch block
            }
            throw var14_26;
        }
        block16: while (true) {
            if ((var7_8 = var6_7.readLine()) != null) {
                if (var1 != null || (var8_9 = var7_8.lastIndexOf("soffice")) == -1) continue;
            } else {
                var15_19 = null;
                if (var6_7 != null) {
                    try {}
                    catch (IOException var16_23) {}
                    var6_7.close();
                }
                try {
                    var3_2.waitFor();
                    return var1;
                }
                catch (InterruptedException var8_11) {
                    var3_2.destroy();
                    Thread.currentThread().interrupt();
                }
                return var1;
            }
            var9_12 = var8_9 + "soffice".length();
            var10_14 = 0;
            while (true) {
                block22: {
                    if (var10_14 > var8_9) continue block16;
                    var11_15 = new File(var7_8.substring(var10_14, var9_12));
                    try {
                        if (!var11_15.exists() || (var1 = var11_15.getCanonicalFile().getParent()) == null) break block22;
                        continue block16;
                    }
                    catch (SecurityException var12_16) {
                        var13_17 = null;
                        var15_18 = null;
                        if (var6_7 == null) return var13_17;
                        ** try [egrp 4[TRYBLOCK] [9 : 279->287)] { 
lbl75:
                        // 1 sources

                        var6_7.close();
                        return var13_17;
lbl77:
                        // 1 sources

                        catch (IOException var16_22) {
                            // empty catch block
                        }
                        return var13_17;
                    }
                }
                ++var10_14;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPathFromSVersionFile() {
        var2 = null;
        try {
            block16: {
                var3_1 = new File(System.getProperty("user.home"), ".sversionrc");
                if (var3_1.exists() == false) return var2;
                var4_3 = new Vector<String>();
                var5_4 = null;
                try {
                    try {
                        var5_4 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(var3_1), "UTF-8"));
                        var6_5 = null;
                        while ((var6_5 = var5_4.readLine()) != null && !var6_5.equals("[Versions]")) {
                        }
                        while ((var6_5 = var5_4.readLine()) != null && var6_5.length() != 0) {
                            if (var6_5.startsWith(";")) continue;
                            var4_3.add(var6_5);
                        }
                        var8_8 = null;
                        if (var5_4 == null) break block16;
                    }
                    catch (IOException var6_6) {
                        System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromSVersionFile: reading .sversionrc file failed: " + var6_6);
                        var8_8 = null;
                        if (var5_4 != null) {
                            try {
                                var5_4.close();
                            }
                            catch (IOException var9_10) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable var7_12) {
                    var8_9 = null;
                    if (var5_4 == null) throw var7_12;
                    ** try [egrp 3[TRYBLOCK] [4 : 185->193)] { 
lbl36:
                    // 1 sources

                    var5_4.close();
                    throw var7_12;
lbl38:
                    // 1 sources

                    catch (IOException var9_11) {
                        // empty catch block
                    }
                    throw var7_12;
                }
                try {}
                catch (IOException var9_10) {}
                var5_4.close();
            }
            var6_7 = var4_3.size() - 1;
            while (var6_7 >= 0) {
                var7_13 = new StringTokenizer((String)var4_3.elementAt(var6_7), "=");
                if (var7_13.countTokens() == 2) {
                    var8_8 = var7_13.nextToken();
                    var9_10 = var7_13.nextToken();
                    var2 = InstallationFinder.getCanonicalPathFromFileURL((String)var9_10);
                    if (var2 != null) {
                        return var2;
                    }
                }
                --var6_7;
            }
            return var2;
        }
        catch (SecurityException var3_2) {
            return null;
        }
    }

    private static String getCanonicalPathFromFileURL(String string) {
        String string2;
        block23: {
            URL uRL;
            Object object;
            Object object2;
            String string3;
            String string4 = "file://";
            if (string.length() < string4.length() || !string.substring(0, string4.length()).toLowerCase().equals(string4)) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n = string.indexOf(47, string4.length());
            if (n < 0) {
                n = string.length();
            }
            if ((string3 = string.substring(string4.length(), n)).length() != 0 && !string3.toLowerCase().equals("localhost")) {
                return null;
            }
            stringBuffer.append(string3);
            if (n == string.length()) {
                stringBuffer.append('/');
            } else {
                block12: while (n < string.length()) {
                    stringBuffer.append('/');
                    int n2 = string.indexOf(47, ++n);
                    if (n2 < 0) {
                        n2 = string.length();
                    }
                    block13: while (n < n2) {
                        char c = string.charAt(n);
                        switch (c) {
                            case '%': {
                                object2 = new byte[(n2 - n) / 3];
                                int n3 = 0;
                                while (string.length() - n > 2 && string.charAt(n) == '%') {
                                    int n4 = Character.digit(string.charAt(n + 1), 16);
                                    int n5 = Character.digit(string.charAt(n + 2), 16);
                                    if (n4 < 0 || n5 < 0) break;
                                    int n6 = 16 * n4 + n5;
                                    if (n6 == 47) {
                                        return null;
                                    }
                                    object2[n3++] = (byte)n6;
                                    n += 3;
                                }
                                try {
                                    object = new String((byte[])object2, 0, n3, "UTF-8");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    return null;
                                }
                                stringBuffer.append((String)object);
                                continue block13;
                            }
                            case '#': {
                                break block12;
                            }
                            default: {
                                stringBuffer.append(c);
                                ++n;
                                continue block13;
                            }
                        }
                    }
                }
            }
            try {
                uRL = new URL(stringBuffer.toString());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            String string5 = uRL.getFile();
            object2 = uRL.getRef();
            if (object2 != null) {
                string5 = string5 + '#' + (String)object2;
            }
            string2 = null;
            object = new File(string5, SOFFICE);
            try {
                if (!((File)object).isAbsolute() || !((File)object).exists()) break block23;
                try {
                    string2 = ((File)object).getCanonicalFile().getParent();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return string2;
    }

    private static final class StreamGobbler
    extends Thread {
        InputStream m_istream;

        StreamGobbler(InputStream inputStream) {
            this.m_istream = inputStream;
        }

        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_istream));
                while (bufferedReader.readLine() != null) {
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

