/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.loader;

import com.sun.star.lib.loader.WinRegKeyException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

final class WinRegKey {
    private String m_rootKeyName;
    private String m_subKeyName;
    static /* synthetic */ Class class$com$sun$star$lib$loader$WinRegKey;

    private static native boolean winreg_RegOpenClassesRoot(long[] var0);

    private static native boolean winreg_RegOpenCurrentConfig(long[] var0);

    private static native boolean winreg_RegOpenCurrentUser(long[] var0);

    private static native boolean winreg_RegOpenLocalMachine(long[] var0);

    private static native boolean winreg_RegOpenUsers(long[] var0);

    private static native boolean winreg_RegOpenKeyEx(long var0, String var2, long[] var3);

    private static native boolean winreg_RegCloseKey(long var0);

    private static native boolean winreg_RegQueryValueEx(long var0, String var2, long[] var3, byte[] var4, long[] var5);

    private static native boolean winreg_RegQueryInfoKey(long var0, long[] var2, long[] var3, long[] var4, long[] var5, long[] var6, long[] var7);

    public WinRegKey(String string, String string2) {
        this.m_rootKeyName = string;
        this.m_subKeyName = string2;
    }

    public String getStringValue(String string) throws WinRegKeyException {
        byte[] byArray = this.getValue(string);
        return new String(byArray, 0, byArray.length - 1);
    }

    private byte[] getValue(String string) throws WinRegKeyException {
        byte[] byArray = null;
        long[] lArray = new long[]{0L};
        boolean bl = false;
        long[] lArray2 = new long[]{0L};
        if (this.m_rootKeyName.equals("HKEY_CLASSES_ROOT")) {
            bl = WinRegKey.winreg_RegOpenClassesRoot(lArray2);
        } else if (this.m_rootKeyName.equals("HKEY_CURRENT_CONFIG")) {
            bl = WinRegKey.winreg_RegOpenCurrentConfig(lArray2);
        } else if (this.m_rootKeyName.equals("HKEY_CURRENT_USER")) {
            bl = WinRegKey.winreg_RegOpenCurrentUser(lArray2);
        } else if (this.m_rootKeyName.equals("HKEY_LOCAL_MACHINE")) {
            bl = WinRegKey.winreg_RegOpenLocalMachine(lArray2);
        } else if (this.m_rootKeyName.equals("HKEY_USERS")) {
            bl = WinRegKey.winreg_RegOpenUsers(lArray2);
        } else {
            throw new WinRegKeyException("unknown root registry key!");
        }
        if (!bl) {
            throw new WinRegKeyException("opening root registry key failed!");
        }
        if (!WinRegKey.winreg_RegOpenKeyEx(lArray2[0], this.m_subKeyName, lArray)) {
            if (!WinRegKey.winreg_RegCloseKey(lArray2[0])) {
                throw new WinRegKeyException("opening registry key and releasing root registry key handle failed!");
            }
            throw new WinRegKeyException("opening registry key failed!");
        }
        long[] lArray3 = new long[]{0L};
        long[] lArray4 = new long[]{0L};
        long[] lArray5 = new long[]{0L};
        long[] lArray6 = new long[]{0L};
        long[] lArray7 = new long[]{0L};
        long[] lArray8 = new long[]{0L};
        if (!WinRegKey.winreg_RegQueryInfoKey(lArray[0], lArray3, lArray4, lArray5, lArray6, lArray7, lArray8)) {
            if (!WinRegKey.winreg_RegCloseKey(lArray[0]) || !WinRegKey.winreg_RegCloseKey(lArray2[0])) {
                throw new WinRegKeyException("retrieving information about the registry key and releasing registry key handles failed!");
            }
            throw new WinRegKeyException("retrieving information about the registry key failed!");
        }
        long[] lArray9 = new long[]{0L};
        byte[] byArray2 = new byte[(int)lArray7[0]];
        long[] lArray10 = new long[]{byArray2.length};
        if (!WinRegKey.winreg_RegQueryValueEx(lArray[0], string, lArray9, byArray2, lArray10)) {
            if (!WinRegKey.winreg_RegCloseKey(lArray[0]) || !WinRegKey.winreg_RegCloseKey(lArray2[0])) {
                throw new WinRegKeyException("retrieving data for the specified value name and releasing registry key handles failed!");
            }
            throw new WinRegKeyException("retrieving data for the specified value name failed!");
        }
        if (!WinRegKey.winreg_RegCloseKey(lArray[0]) || !WinRegKey.winreg_RegCloseKey(lArray2[0])) {
            throw new WinRegKeyException("releasing registry key handles failed!");
        }
        byArray = new byte[(int)lArray10[0]];
        System.arraycopy(byArray2, 0, byArray, 0, (int)lArray10[0]);
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            ClassLoader classLoader = (class$com$sun$star$lib$loader$WinRegKey == null ? (class$com$sun$star$lib$loader$WinRegKey = WinRegKey.class$("com.sun.star.lib.loader.WinRegKey")) : class$com$sun$star$lib$loader$WinRegKey).getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("win/unowinreg.dll");
            if (inputStream != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                File file = File.createTempFile("unowinreg", ".dll");
                file.deleteOnExit();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n = 2048;
                int n2 = 0;
                byte[] byArray = new byte[n];
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
                bufferedInputStream.close();
                bufferedOutputStream.close();
                System.load(file.getPath());
            } else {
                System.loadLibrary("unowinreg");
            }
        }
        catch (Exception exception) {
            System.err.println("com.sun.star.lib.loader.WinRegKey: loading of native library failed!" + exception);
        }
    }
}

