# --
# Kernel/Modules/AgentEmail.pm - to compose and send a message
# Copyright (C) 2003 Gilles Massen
# Created by copy-paste from AgentCompose.pm and AgentPhoneNew.pm
# copyrighted by Martin Edenhofer <martin+code@otrs.org>
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --

package Kernel::Modules::AgentEmail;

use strict;
use Kernel::System::CheckItem;
use Kernel::System::StdAttachment;
use Kernel::System::State;
use Kernel::System::CustomerUser;
use Mail::Address;

use vars qw($VERSION);
$VERSION = '$Revision: 1.46 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub new {
    my $Type = shift;
    my %Param = @_;
   
    # allocate new hash for object 
    my $Self = {}; 
    bless ($Self, $Type);
    
    # get common opjects
    foreach (keys %Param) {
        $Self->{$_} = $Param{$_};
    }

    # check all needed objects
    foreach (qw(TicketObject ParamObject DBObject QueueObject LayoutObject
      ConfigObject LogObject)) {
        die "Got no $_" if (!$Self->{$_});
    }
    # some new objects
    $Self->{CustomerUserObject} = Kernel::System::CustomerUser->new(%Param);
    $Self->{CheckItemObject} = Kernel::System::CheckItem->new(%Param);
    $Self->{StdAttachmentObject} = Kernel::System::StdAttachment->new(%Param);
    $Self->{StateObject} = Kernel::System::State->new(%Param);
    $Self->{SystemAddress} = Kernel::System::SystemAddress->new(%Param);
    # --
    # get params
    # --
    foreach (qw(From To Cc Bcc Subject Body InReplyTo ResponseID ComposeStateID 
      Answered ArticleID TimeUnits Year Month Day Hour Minute)) {
        my $Value = $Self->{ParamObject}->GetParam(Param => $_);
        $Self->{$_} = defined $Value ? $Value : '';
    }
    # -- 
    # get response format
    # --
    $Self->{ResponseFormat} = $Self->{ConfigObject}->Get('ResponseFormat') ||
      '$Data{"Salutation"}
$Data{"OrigFrom"} $Text{"wrote"}:
$Data{"Body"}

$Data{"StdResponse"}

$Data{"Signature"}
';
    return $Self;
}
# --
sub Run {
    my $Self = shift;
    my %Param = @_;
    my $Output;
    
    if ($Self->{Subaction} eq 'SendEmail') {
        $Output = $Self->SendEmail();
    }
    else {
        $Output = $Self->Form();
    }
    return $Output;
}
# --
sub Form {
    my $Self = shift;
    my %Param = @_;
    my $Output;
#    my NextScreen = $Self->{NextScreen} || 'AgentZoom';
    my $UserLogin = $Self->{UserLogin};
    # -- 
    # start with page ...
    # --
    $Output .= $Self->{LayoutObject}->Header(Title => 'AgentEmail');
    # -- 
    if (!$Self->{TicketID}) {
	    my %LockedData = $Self->{TicketObject}->GetLockedCount(UserID => $Self->{UserID});
            $Output .= $Self->{LayoutObject}->NavigationBar(LockData => \%LockedData);
#            # --
#            # get split article if given
#            # --
#            # get ArticleID
#            my $ArticleID = $Self->{ParamObject}->GetParam(Param => 'ArticleID'); 
#            my %Article = ();
#            my %CustomerData = ();
#            if ($ArticleID) {
#                %Article = $Self->{TicketObject}->GetArticle(ArticleID => $ArticleID);
#                my $TicketHook = $Self->{ConfigObject}->Get('TicketHook');
#                $Article{Subject} =~ s/\[${TicketHook}:\s*\d+\](\s|)//;
#                # --
#                # check if original content isn't text/plain or text/html, don't use it
#                # --
#                if ($Article{'ContentType'}) {
#                    if($Article{'ContentType'} =~ /text\/html/i) {
#                        $Article{Body} =~ s/\<.+?\>//gs;
#                    }
#                    elsif ($Article{'ContentType'} !~ /text\/plain/i) {
#                        $Article{Body} = "-> no quotable message <-";
#                    }
#                }
#                # --
#                # show customer info
#                # --
#                if ($Self->{ConfigObject}->Get('ShowCustomerInfoPhone')) {
#                  if ($Article{CustomerUserID}) {
#                    %CustomerData = $Self->{CustomerUserObject}->CustomerUserDataGet(
#                         User => $Article{CustomerUserID},
#                    );
#                  }
#                  elsif ($Article{CustomerID}) {
#                    %CustomerData = $Self->{CustomerUserObject}->CustomerUserDataGet(
#                        CustomerID => $Article{CustomerID},
#                    );
#                  }
#                }
#           }
            # --
            # html output
            # --

            $Output .= $Self->{LayoutObject}->AgentEmail(
              QueueID => $Self->{QueueID},
#              NextScreen => $NextScreen,
              NextStates => $Self->_GetNextStates(),
              Priorities => $Self->_GetPriorities(), 
              Users => $Self->_GetUsers(),
              From => $Self->_GetTos(),
#              To => $Article{From},
              Subject => '',
              Body => '',
#              CustomerID => $Article{CustomerID},
#              CustomerUser => $Article{CustomerUserID},
#              CustomerData => \%CustomerData,
            );
            $Output .= $Self->{LayoutObject}->Footer();
            return $Output;
    }

#    # --
#    # check some values
#    # --
#    my %Error = ();
#    foreach (qw(From To Cc Bcc)) {
#        if ($Data{$_}) {
#            foreach my $Email (Mail::Address->parse($Data{$_})) {
#                if (!$Self->{CheckItemObject}->CkeckEmail(Address => $Email->address())) {
#                     $Error{"$_ invalid"} .= $Self->{CheckItemObject}->CheckError();
#                }
#            }
#        }
#    }

} #--end of sub Form


# --
sub SendEmail {
    my $Self = shift;
    my %Param = @_;
    my $Output = '';
    my $QueueID = $Self->{QueueID};
#    my $NextState = $Self->{TicketObject}->StateIDLookup(StateID => $Self->{ComposeStateID});
    # --
    # get attachment
    # -- 
    my %UploadStuff = $Self->{ParamObject}->GetUploadAll(
        Param => 'file_upload',
        Source => 'string',
    );
    # --
    # get std attachment ids
    # --
    my @StdAttachmentIDs = $Self->{ParamObject}->GetArray(Param => 'StdAttachmentID');

# -- inserted
        my $Subject = $Self->{ParamObject}->GetParam(Param => 'Subject') || '';
        my $Text = $Self->{ParamObject}->GetParam(Param => 'Body') || '';
        my $NextStateID = $Self->{ParamObject}->GetParam(Param => 'NextStateID') || '';
        my $NextState = $Self->{TicketObject}->StateIDLookup(StateID => $NextStateID);
        my $PriorityID = $Self->{ParamObject}->GetParam(Param => 'PriorityID') || '';
        my $ArticleTypeID = $Self->{ParamObject}->GetParam(Param => 'NoteID');
        my $NewUserID = $Self->{ParamObject}->GetParam(Param => 'NewUserID') || '';
        my $Sender = $Self->{ParamObject}->GetParam(Param => 'From') || '';
        my ($NewQueueID, $From) = split(/\|\|/, $Sender); 
        my $To = $Self->{ParamObject}->GetParam(Param => 'To') || '';
        my $Cc = $Self->{ParamObject}->GetParam(Param => 'Cc') || '';
        my $TimeUnits = $Self->{ParamObject}->GetParam(Param => 'TimeUnits') || '';
        my $CustomerUser = $Self->{ParamObject}->GetParam(Param => 'CustomerUser') || '';
        my $SelectedCustomerUser = $Self->{ParamObject}->GetParam(Param => 'SelectedCustomerUser') || '';
        my $ExpandCustomerName = $Self->{ParamObject}->GetParam(Param => 'ExpandCustomerName') || 0;
        my $CustomerID = $Self->{ParamObject}->GetParam(Param => 'CustomerID') || '';
        my %GetParam = ();
        foreach (qw(Year Month Day Hour Minute)) {
            $GetParam{$_} = $Self->{ParamObject}->GetParam(Param => $_);
        }
        my %Error = ();
#        # --
#        # Expand Customer Name
#        # -- 
#        my %CustomerUserData = ();
#        if ($ExpandCustomerName == 1) {
#            # search customer 
#            my %CustomerUserList = ();
#            %CustomerUserList = $Self->{CustomerUserObject}->CustomerSearch(
#                Search => $From.'*',
#            );
#            # check if just one customer user exists
#            # if just one, fillup CustomerUserID and CustomerID
#            $Param{CustomerUserListCount} = 0;
#            foreach (keys %CustomerUserList) {
#                $Param{CustomerUserListCount}++;
#                $Param{CustomerUserListLast} = $CustomerUserList{$_};
#                $Param{CustomerUserListLastUser} = $_;
#            }
#            if ($Param{CustomerUserListCount} == 1) {
#                $From = $Param{CustomerUserListLast};
#                $Error{"ExpandCustomerName"} = 1;
#                my %CustomerUserData = $Self->{CustomerUserObject}->CustomerUserDataGet(
#                    User => $Param{CustomerUserListLastUser},
#                );
#                if ($CustomerUserData{UserCustomerID}) {
#                    $CustomerID = $CustomerUserData{UserCustomerID};
#                } 
#                if ($CustomerUserData{UserLogin}) {
#                    $CustomerUser = $CustomerUserData{UserLogin};
#                } 
#            }
#            # if more the one customer user exists, show list
#            # and clean CustomerUserID and CustomerID
#            else {
#                $From = '';
#                $CustomerID = '';
#                $Param{"ToOptions"} = \%CustomerUserList;
#                $Error{"ExpandCustomerName"} = 1;
#            }
#        }
#        # --
#        # get from and customer id if customer user is given
#        # --
#        elsif ($ExpandCustomerName == 2) {
#            %CustomerUserData = $Self->{CustomerUserObject}->CustomerUserDataGet(
#                User => $CustomerUser,
#            );
#            my %CustomerUserList = $Self->{CustomerUserObject}->CustomerSearch(
#                UserLogin => $CustomerUser,
#            );
#           foreach (keys %CustomerUserList) {
#                $From = $CustomerUserList{$_};
#            }
#            if ($CustomerUserData{UserCustomerID}) {
#                $CustomerID = $CustomerUserData{UserCustomerID};
#            } 
#            if ($CustomerUserData{UserLogin}) {
#                $CustomerUser = $CustomerUserData{UserLogin};
#            } 
#            $Error{"ExpandCustomerName"} = 1;
#        }
#        # --
#        # show customer info
#        # --
#        my %CustomerData = ();
#        if ($Self->{ConfigObject}->Get('ShowCustomerInfoPhone')) {
#            if ($CustomerUser) {
#                %CustomerData = $Self->{CustomerUserObject}->CustomerUserDataGet(
#                    User => $CustomerUser,
#                ); 
#            }
#            elsif ($CustomerID) {
#                %CustomerData = $Self->{CustomerUserObject}->CustomerUserDataGet(
#                    CustomerID => $CustomerID,
#                );
#            }
#        }


    # --
    # check some values
    # --
         foreach (qw(To Cc)) {
             if ($Self->{$_}) {
                 foreach my $Email (Mail::Address->parse($Self->{$_})) {
                     if (!$Self->{CheckItemObject}->CkeckEmail(Address => $Email->address())) {
                         $Error{"$_ invalid"} .= $Self->{CheckItemObject}->CheckError();
                     }
                 }
             }
         } 

#        # --
#        # check some values
#        # --
#        foreach my $Email (Mail::Address->parse($To)) {
#            if (!$Self->{CheckItemObject}->CkeckEmail(Address => $Email->address())) {
#                $Error{"To invalid"} .= $Self->{CheckItemObject}->CheckError();
#            }
#        }
#        if (!$From && $ExpandCustomerName != 1) {
#            $Error{"From invalid"} = 'from invalid';
#        }
        if (!$Subject) {
            $Error{"Subject invalid"} = 'subject invalid';
        }
        if (%Error) {
            # --
            # header
            # --
            $Output .= $Self->{LayoutObject}->Header(Title => 'Error - AgentEmail');
            my %LockedData = $Self->{TicketObject}->GetLockedCount(UserID => $Self->{UserID});
            $Output .= $Self->{LayoutObject}->NavigationBar(LockData => \%LockedData);
            # --
            # html output
            # --
            $Output .= $Self->{LayoutObject}->AgentEmail(
              QueueID => $Self->{QueueID},
#              NextScreen => $NextScreen,
              Users => $Self->_GetUsers(),
              UserSelected => $NewUserID,
              NextStates => $Self->_GetNextStates(),
              NextState => $NextState,
              Priorities => $Self->_GetPriorities(),
              PriorityID => $PriorityID,
              CustomerID => $CustomerID,
              CustomerUser => $CustomerUser,
#              CustomerData => \%CustomerData,
              TimeUnits => $TimeUnits,
              From => $From,
              ToOptions => $Param{"ToOptions"},
              Body => $Text,
              From => $Self->_GetTos(),
              FromSelected => $Sender,
	      To => $To,
	      Cc => $Cc,
              Subject => $Subject,
              Errors => \%Error,
              %GetParam,
           );
            $Output .= $Self->{LayoutObject}->Footer();
            return $Output;
        }
        # --
        # create new ticket
        # --
        my $NewTn = $Self->{TicketObject}->CreateTicketNr();
        # --
        # do db insert
        # --
        my $TicketID = $Self->{TicketObject}->CreateTicketDB(
            TN => $NewTn,
            QueueID => $NewQueueID,
            Lock => 'unlock',
            # FIXME !!!
            GroupID => 1,
            StateID => $NextStateID,
            PriorityID => $PriorityID,
            UserID => $Self->{UserID},
            CreateUserID => $Self->{UserID},
        );

        # Format Subject
        my $TicketHook = $Self->{ConfigObject}->Get('TicketHook');
        $Subject = "[$TicketHook: $NewTn] ".$Subject;

        # --
        # check if new owner is given (then send no agent notify)
        # --
        my $NoAgentNotify = 0;
        if ($NewUserID) {
            $NoAgentNotify = 1;
        }
        #Rewrite From
        my $QueueObject = Kernel::System::Queue->new(
						     QueueID => $NewQueueID,
						     DBObject => $Self->{DBObject},
						     ConfigObject => $Self->{ConfigObject},
						     LogObject => $Self->{LogObject},
						     );
        my %Address = $QueueObject->GetSystemAddress();
        $From = "$Address{RealName} <$Address{Email}>";

        # Append Signature
        my $Signature = $QueueObject->GetSignature();
        $Signature =~ s/<OTRS_FIRST_NAME>/$Self->{UserFirstname}/g;
        $Signature =~ s/<OTRS_LAST_NAME>/$Self->{UserLastname}/g;
        $Signature =~ s/<OTRS_USER_ID>/$Self->{UserID}/g;
        $Signature =~ s/<OTRS_USER_LOGIN>/$Self->{UserLogin}/g;
        $Text = $Text . "\n" . $Signature;
    
        if ( 
            my $ArticleID = $Self->{TicketObject}->CreateArticle(
            NoAgentNotify => $NoAgentNotify,
            TicketID => $TicketID,
            ArticleType => $Self->{ConfigObject}->Get('PhoneDefaultNewArticleType'),
            SenderType => $Self->{ConfigObject}->Get('PhoneDefaultNewSenderType'),
            From => $From,
            To => $To,
            Subject => $Subject,
            Body => $Text,
            ContentType => "text/plain; charset=$Self->{'UserCharset'}",
            UserID => $Self->{UserID},
            HistoryType => 'NewTicket',								
            HistoryComment => "Created New Message.",
            AutoResponseType => 'auto reply',
            OrigHeader => {
              From => $From,
              To => $To,
              Subject => $Subject,
              Body => $Text,
            },
            Queue => $Self->{QueueObject}->QueueLookup(QueueID => $NewQueueID),
        )
	    ) {
          # --
          # set lock (get lock type)
          # --
          my $Lock = $Self->{ConfigObject}->Get('PhoneDefaultNewLock') || 'lock';
          if ($NewUserID) {
              $Lock = 'lock';
          }
          $Self->{TicketObject}->SetLock(
              TicketID => $TicketID,
              Lock => $Lock, 
              UserID => $Self->{UserID},
          );
          # --
          # set owner (if new user id is given)
          # --
          if ($NewUserID) {
              $Self->{TicketObject}->SetOwner(
                  TicketID => $TicketID, 
                  NewUserID => $NewUserID,
                  UserID => $Self->{UserID},
              );
          }
          # --
          # time accounting
          # --
          if ($TimeUnits) {
              $Self->{TicketObject}->AccountTime(
                  TicketID => $TicketID,
                  ArticleID => $ArticleID,
                  TimeUnit => $TimeUnits,
                  UserID => $Self->{UserID},
              );
          }
          # --
          # set custoemr id
          # --
          if ($CustomerID || $SelectedCustomerUser) {
              $Self->{TicketObject}->SetCustomerData(
                  TicketID => $TicketID,
                  No => $CustomerID, 
                  User => $SelectedCustomerUser,
                  UserID => $Self->{UserID},
              );
          }
          # --
          # should i set an unlock?
          # --
          my %StateData = $Self->{StateObject}->StateGet(ID => $NextStateID);
          if ($StateData{TypeName} =~ /^close/i) {
              $Self->{TicketObject}->SetLock(
                  TicketID => $TicketID,
                  Lock => 'unlock',
                  UserID => $Self->{UserID},
              );
          }
          # --
          # set pending time
          # --
          elsif ($StateData{TypeName} =~ /^pending/i) {
              $Self->{TicketObject}->SetPendingTime(
                  UserID => $Self->{UserID},
                  TicketID => $TicketID,
                  %GetParam,
              );
          }
      }
      else {
          $Output = $Self->{LayoutObject}->Header(Title => 'Error');
          $Output .= $Self->{LayoutObject}->Error();
          $Output .= $Self->{LayoutObject}->Footer();
          return $Output;
      }
#--end of inserted

    # --
    # send email
    # --


    if (my $ArticleID = $Self->{TicketObject}->SendArticle(
        Attach => [\%UploadStuff],
        ArticleType => 'email-external',
        SenderType => 'agent',
        TicketID => $TicketID,
        HistoryType => 'NewTicket',
        HistoryComment => "Sent email to '$Self->{To}'.",
        From => $From,
        To => $Self->{To},
        Cc => $Self->{Cc},
        Subject => $Subject,
        UserID => $Self->{UserID},
        Body => $Text,
        InReplyTo => $Self->{InReplyTo},
        Charset => $Self->{UserCharset},
        StdAttachmentIDs => \@StdAttachmentIDs,
    )) {
        # --
        # time accounting
        # --
        if ($Self->{TimeUnits}) {
            $Self->{TicketObject}->AccountTime(
                TicketID => $Self->{TicketID},
                ArticleID => $ArticleID,
                TimeUnit => $Self->{TimeUnits},
                UserID => $Self->{UserID},
            );
        }
        # --
        # set state
        # --
        $Self->{TicketObject}->SetState(
            TicketID => $Self->{TicketID},
            ArticleID => $ArticleID,
            State => $NextState,
            UserID => $Self->{UserID},
        );
        # --
        # set answerd
        # --
        $Self->{TicketObject}->SetAnswered(
            TicketID => $Self->{TicketID},
            UserID => $Self->{UserID},
            Answered => $Self->{Answered},
        );
        # --
        # should i set an unlock?
        # --
        my %StateData = $Self->{StateObject}->StateGet(ID => $Self->{ComposeStateID});
        if ($StateData{TypeName} =~ /^close/i) {
            $Self->{TicketObject}->SetLock(
                TicketID => $Self->{TicketID},
                Lock => 'unlock',
                UserID => $Self->{UserID},
            );
        }
        # --
        # set pending time
        # --
        elsif ($StateData{TypeName} =~ /^pending/i) {
            $Self->{TicketObject}->SetPendingTime(
                UserID => $Self->{UserID},
                TicketID => $Self->{TicketID},
                Year => $Self->{Year},
                Month => $Self->{Month},
                Day => $Self->{Day},
                Hour => $Self->{Hour},
                Minute => $Self->{Minute},
            );
        }
        # --
        # redirect
        # --
        return $Self->{LayoutObject}->Redirect(OP => $Self->{LastScreen});
        # or else: OP => "Action=$NextScreen&QueueID=$Self->{QueueID}&TicketID=$TicketID"     
    }
    else {
      # --
      # error page
      # --
      $Output .= $Self->{LayoutObject}->Header(Title => 'Compose');
      $Output .= $Self->{LayoutObject}->Error(
          Comment => 'Please contact the admin.',
      );
      $Output .= $Self->{LayoutObject}->Footer();
      return $Output;
    }
}
# --
sub _GetNextStates {
    my $Self = shift;
    my %Param = @_;
    # --
    # get next states
    # --
    my %NextStates = $Self->{StateObject}->StateGetStatesByType(
        Type => 'DefaultNextCompose',
        Result => 'HASH',
    );
    return \%NextStates;
}
# --
# --
sub _GetUsers {
    my $Self = shift;
    my %Param = @_;
    # -- 
    # get users 
    # --
    my %ShownUsers = ();
    my %AllGroupsMembers = $Self->{UserObject}->UserList(
        Type => 'Long',
        Valid => 1,
    );
    if ($Self->{ConfigObject}->Get('ChangeOwnerToEveryone')) {
        %ShownUsers = %AllGroupsMembers;
    }
    else {
        my %Groups = $Self->{GroupObject}->GroupUserList(
            UserID => $Self->{UserID},
            Type => 'rw',
            Result => 'HASH',
        );
        foreach (keys %Groups) {
            my %MemberList = $Self->{GroupObject}->GroupMemberList(
                    GroupID => $_,
                    Type => 'rw',
                    Result => 'HASH',
            );
            foreach (keys %MemberList) {
                    $ShownUsers{$_} = $AllGroupsMembers{$_};
            }
        }
    }
    return \%ShownUsers;
}
# --
sub _GetPriorities {
    my $Self = shift;
    my %Param = @_;
    # -- 
    # get priority
    # --
    my %Priorities = $Self->{DBObject}->GetTableData(
        What => 'id, name',
        Table => 'ticket_priority',
    );
    return \%Priorities;
}
# --
sub _GetTos {
    my $Self = shift;
    my %Param = @_;
    # --
    # check own selection
    # --
    my %NewTos = ();
    if ($Self->{ConfigObject}->{PhoneViewOwnSelection}) {
        %NewTos = %{$Self->{ConfigObject}->{PhoneViewOwnSelection}};
    }
    else {
        # --
        # SelectionType Queue or SystemAddress?    
        # --
        my %Tos = ();
        if ($Self->{ConfigObject}->Get('PhoneViewSelectionType') eq 'Queue') {
            %Tos = $Self->{QueueObject}->GetAllQueues();
        }
        else {
            %Tos = $Self->{DBObject}->GetTableData(
                Table => 'system_address',
                What => 'queue_id, id',
                Valid => 1,
                Clamp => 1,
            );
        }
        # --
        # ASP? Just options where the user is in!
        # --
        if ($Self->{ConfigObject}->Get('PhoneViewASP')) {
            my %UserGroups = $Self->{GroupObject}->GroupUserList(
                UserID => $Self->{UserID}, 
                Type => 'rw', 
                Result => 'HASH',
            );
            foreach (keys %Tos) {
                if ($UserGroups{$Self->{QueueObject}->GetQueueGroupID(QueueID => $_)}) {
                    $NewTos{$_} = $Tos{$_};
                }
            }
        }
        else {
            %NewTos = %Tos;
        }
        # --
        # build selection string
        # --
        foreach (keys %NewTos) {
            my %QueueData = $Self->{QueueObject}->QueueGet(ID => $_);
            my $Srting = $Self->{ConfigObject}->Get('PhoneViewSelectionString') || '<Realname> <<Email>> - Queue: <Queue>';
            $Srting =~ s/<Queue>/$QueueData{Name}/g;
            $Srting =~ s/<QueueComment>/$QueueData{Comment}/g;
            if ($Self->{ConfigObject}->Get('PhoneViewSelectionType') ne 'Queue') {
                my %SystemAddressData = $Self->{SystemAddress}->SystemAddressGet(ID => $NewTos{$_});
                $Srting =~ s/<Realname>/$SystemAddressData{Realname}/g;
                $Srting =~ s/<Email>/$SystemAddressData{Name}/g;
            }
            $NewTos{$_} = $Srting;
        }
    }
    return \%NewTos;
}
# --

1;
