# --
# Kernel/System/PostMaster/Filter/Simple.pm - sub part of PostMaster.pm
# Copyright (C) 2001-2003 Martin Edenhofer <martin+code otrs.org>
# --
# $Id: developer-guide-custom-modules.sgml,v 1.5 2004/02/08 22:26:45 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --

package Kernel::System::PostMaster::Filter::Simple;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.5 $';
$VERSION =~ s/^.*:\s(\d+\.\d+)\s.*$/$1/;

# --
sub new {
    my $Type = shift;
    my %Param = @_;

    # allocate new hash for object
    my $Self = {};
    bless ($Self, $Type);

    $Self->{Debug} = $Param{Debug} || 0;

	$Self->{SendmailObject} = Kernel::System::Email->new(%Param);

    # get needed objects
    foreach (qw(ConfigObject LogObject DBObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}
# --
sub Run {
	my $Self = shift;
    my %Param = @_;
	# Ignore all message received when the system is include as a "cc:".
	if ($Param{GetParam}->{Cc} =~ /helpdesk\@example.com/i) {
        $Param{GetParam}->{'X-OTRS-Ignore'} = 'yes';
		if ($Self->{SendmailObject}->Send(
			From => 'helpdesk@example.com',
			To => $Param{GetParam}->{From},
			Subject => 'Help Desk System Notification',
			Body => "The Help Desk received a carbon copy of a message sent to $Param{GetParam}->{To}. ".
					"This message was not processed because the Help Desk was not the ".
					"primary recipient of the message.  If you wish for the Help Desk to open a case ".
					"on this, please resubmit your email to <helpdesk\@example.com> as the only ".
					"\"To:\" recipient.\n\n".
					"**This is an automated message.  You do not need to reply to it.",)) {
				print "Email sent!\n";
		}
		else {
			print "Email not sent!\n";
		}
	}
	# Ignore all message received when the system is include with multiple "To:" recipients.
	if ($Param{GetParam}->{To} =~ /.+?\@.+?,.+?\@.+?/i) {
        $Param{GetParam}->{'X-OTRS-Ignore'} = 'yes';
		if ($Self->{SendmailObject}->Send(
			From => 'helpdesk@example.com',
			To => $Param{GetParam}->{From},
			Subject => 'Help Desk System Notification',
			Body => "The Help Desk received an email that was sent to multiple primary recipients. ".
					"Because the message was addressed to more than one individual, the system could ".
					"not determine the primary owner.  A case was not created from your message.  If you wish for the ".
					"Help Desk to open a case on this, please resubmit your email to <helpdesk\@example.com> as the only ".
					"\"To:\" recipient.\n\n".
					"**This is an automated message.  You do not need to reply to it.",)) {
				print "Email sent!\n";
		}
		else {
			print "Email not sent!\n";
		}
	}
	return 1;
}
# --
1;
