use strict;

use File::Copy ();
use File::Spec::Functions;
use Config;

my $VERSION = '1.01';

my $mp_version;

# which mod_perl version is wanted
# perl Makefile.PL MOD_PERL2=1
my %args = map {split /=/, $_ } @ARGV;
if ($ENV{MOD_PERL2} || $args{MOD_PERL2}) {
    #warn "Looking for mod_perl 2.0";
    require Apache2;
    require mod_perl;
    if ($mod_perl::VERSION < 1.99) {
        die "You don't seem to have mod_perl 2.0 installed";
    }
    $mp_version = 2;
} else {
    require mod_perl;
    $mp_version = 1;
}
warn "Goind to build against mod_perl/$mod_perl::VERSION Perl/$]\n";

# now figure out the perl version
my $perl_version = eval { require 5.8.0 }    ? "5.8"
        : eval { require 5.6.0 }    ? "5.6"
        : eval { require 5.005_03 } ? "5.5"
        : die "unsupported Perl version";

# currently we support only 5.8-perlio
if ($perl_version eq '5.8') {
    die "Perl must be built with PerlIO support in order to use this module"
        unless $Config{useperlio};
}

# now put together the build
my %files = map { $_ => join '.', $_, "mp$mp_version", "perl$perl_version" }
    ("Peek.pm", "Peek.xs");

# copy the xs file as is
File::Copy::copy($files{"Peek.xs"}, "Peek.xs");

# adjust the version and glue the doc (ugly open for 5.005_03 support)
my ($in, $out) = ($files{"Peek.pm"}, "Peek.pm");
open IN,  "<$in"  or die "can't open $in: $!";
open OUT, ">$out" or die "can't open $out: $!";
while (<IN>) {
    s/(.*\$VERSION\s*=).*/$1 $VERSION;/;
    print OUT $_;
}
print OUT <DATA>;
close IN;
close OUT;

if ($mp_version == 1) {
    eval { require Apache::src };
    if ($@) {
        die "You need to install mod_perl for this version of Perl: $@";
    }
    my $inc = Apache::src->new->inc;
    die "Can't find mod_perl header files installed" unless $inc;

    require ExtUtils::MakeMaker;
    ExtUtils::MakeMaker::WriteMakefile(
        NAME => "Apache::Peek",
        VERSION_FROM => "Peek.pm",
        XSPROTOARG   => '-noprototypes',
        INC	     => $inc,
        LIBS         => [''],
        DEFINE       => '-DMOD_PERL',
        MAN3PODS     => {},
    );

}
else {
    require ModPerl::MM;
    ModPerl::MM::WriteMakefile(
        NAME => "Apache::Peek",
        VERSION_FROM => "Peek.pm",
        XSPROTOARG   => '-noprototypes',
        DEFINE       => '-DMOD_PERL',
        MAN3PODS     => {},
    );
}

__DATA__
__END__
=head1 NAME

Apache::Peek - A data debugging tool for the XS programmer (under mod_perl)

=head1 SYNOPSIS

        use Apache::Peek;
        Dump( $a );
        Dump( $a, 5 );
        DumpArray( 5, $a, $b, ... );

        # more functionality inherited from Devel::Peek

=head1 DESCRIPTION

C<Apache::Peek> is a sub-class of C<Devel::Peek>. The only difference
is that it overrides the stderr stream, to which C<Devel::Peek> sends
its output, and send the output to the client instead.

Note: The following table summarizes what parts of the
C<Devel::Peek>'s API are available, depending on the used Perl version
and configurations:

  5.005_0x                 all
  5.6.x                    only Dump()
  5.8.x (w/  -Duseperlio)  all
  5.8.x (w/o -Duseperlio)  none

Patches to complete the functionality are welcome.

C<Apache::Peek> works both with mod_perl 1.0 and 2.0.

See the C<Devel::Peek> manpage for a complete documentation.

=head1 AUTHOR

Hacking the mod_perl versions:

Doug MacEachern         dougm@pobox.com

Stas Bekman             stas@stason.org

Writing the original C<Devel::Peek>

Ilya Zakharevich	ilya@math.ohio-state.edu

=head1 Copyright

Copyright (c) 1995-98 Ilya Zakharevich. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

Author of this software makes no claim whatsoever about suitability,
reliability, edability, editability or usability of this product, and
should not be kept liable for any damage resulting from the use of
it. If you can use it, you are in luck, if not, I should not be kept
responsible. Keep a handy copy of your backup tape at hand.

=head1 SEE ALSO

L<perlguts>, and L<perlguts>, again.

=cut

EOF
