package TestVhost::basic;

# Test whether vhost with 'PerlOptions +Parent', which doesn't inherit
# from the base, has its own INC and therefore can have a modules with
# the same namespace as the base, but different content.
#
# Also see the parallel TestDirective::perlmodule handler

use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestUtil;

use Apache::RequestUtil ();
use APR::Table ();

use File::Spec::Functions qw(catdir);

use Apache::Const -compile => 'OK';

sub handler {
    my $r = shift;

    plan $r, tests => 1;

    {
        my $expected = $r->document_root;
        my $received = $r->dir_config->get('DocumentRootCheck');
        ok t_cmp($expected, $received, "DocumentRoot");
    }

    Apache::OK;
}

1;
__END__
<NoAutoConfig>
<VirtualHost TestVhost::basic>
    DocumentRoot @documentroot@/vhost

    <IfDefine PERL_USEITHREADS>
        # a new interpreter pool
        PerlOptions +Parent
    </IfDefine>

    # use test system's @INC
    PerlSwitches -I@serverroot@

    # mp2 modules
    PerlRequire "@serverroot@/conf/modperl_inc.pl"

    # private to this vhost stuff
    PerlRequire "@documentroot@/vhost/startup.pl"

    # <Location /TestVhost__basic> container is added via add_config
    # in t/htdocs/vhost/startup.pl
</VirtualHost>
</NoAutoConfig>

