#include "httpd.h"
#include "http_config.h"
#include "http_request.h"
#include "http_protocol.h"
#include "http_log.h"

module AP_MODULE_DECLARE_DATA hook_order_module;

static int post_read_request_handler(request_rec *r)
{
    apr_table_add(r->notes, "postreadrequest", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran postreadrequest from C for %s", r->args);
    return DECLINED;
}

static int trans_handler(request_rec *r)
{
    apr_table_add(r->notes, "trans", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran trans from C for %s", r->args);
    return DECLINED;
}

static int map_to_storage_handler(request_rec *r)
{
    apr_table_add(r->notes, "maptostorage", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran maptostorage from C for %s", r->args);
    return DECLINED;
}

static int header_parser_handler(request_rec *r)
{
    apr_table_add(r->notes, "headerparser", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran headerparser from C for %s", r->args);
    return DECLINED;
}
static int authen_handler(request_rec *r)
{
    apr_table_add(r->notes, "authen", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran authen from C for %s", r->args);
    return DECLINED;
}
static int authz_handler(request_rec *r)
{
    apr_table_add(r->notes, "authz", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran authz from C for %s", r->args);
    return DECLINED;
}
static int access_handler(request_rec *r)
{
    apr_table_add(r->notes, "access", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran access from C for %s", r->args);
    return DECLINED;
}
static int type_handler(request_rec *r)
{
    apr_table_add(r->notes, "type", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran type from C for %s", r->args);
    return DECLINED;
}
static int fixup_handler(request_rec *r)
{
    apr_table_add(r->notes, "fixup", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran fixup from C for %s", r->args);
    return DECLINED;
}
static int log_handler(request_rec *r)
{
    apr_table_add(r->notes, "log", "C");

    ap_log_rerror(APLOG_MARK, APLOG_INFO, 0, r, 
                  "ran log from C for %s", r->args);
    return DECLINED;
}

static void register_hooks(apr_pool_t *p)
{
    ap_hook_post_read_request(post_read_request_handler, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_translate_name(trans_handler, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_map_to_storage(map_to_storage_handler, NULL,NULL, APR_HOOK_FIRST);
    ap_hook_header_parser(header_parser_handler, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_access_checker(access_handler, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_check_user_id(authen_handler, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_auth_checker(authz_handler, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_type_checker(type_handler, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_fixups(fixup_handler, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_log_transaction(log_handler, NULL, NULL, APR_HOOK_FIRST);
}

module AP_MODULE_DECLARE_DATA hook_order_module =
{
    STANDARD20_MODULE_STUFF,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    register_hooks
};
