use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

my $defines = Apache::Test::vars('defines');
my $ok;;

if (! $defines || $defines =~ m/First/) {
  $defines ||= 'default';
  $ok++
}

plan tests => 1, (have_lwp && $ok);

my $uri = "/index.html?$defines";

t_debug("uri: $uri");

my $response = GET $uri;

my $received = $response->content;

my $expected = <<EOF;
postreadrequest: Perl, C
trans: Perl, C
maptostorage: Perl, C
headerparser: Perl, C
access: Perl, C
type: Perl, C
fixup: Perl, C
EOF

ok t_cmp($expected,
         $received,
         'mod_perl is first');
