package My::NotesPrint;

use Apache::RequestRec ();
use Apache::RequestIO ();
use APR::Table ();

use strict;

use APR::Const -compile => 'OVERLAP_TABLES_MERGE';
use Apache::Const -compile => qw(OK);

sub handler {

  my $r = shift;

  $r->content_type('text/plain');

  $r->notes->compress(APR::OVERLAP_TABLES_MERGE);

  foreach my $phase ( qw(postreadrequest trans maptostorage
                         headerparser access type fixup)) {

      $r->print("$phase: ", $r->notes->get($phase), "\n");
  }

  return Apache::OK;
}

1;
