package My::NotesSet;

use Apache::RequestRec ();
use Apache::Log ();
use APR::Table ();
use ModPerl::Util ();

use strict;

use Apache::Const -compile => qw(DECLINED);

sub handler {

  my $r = shift;

  my ($callback) = Apache::current_callback =~ m/Perl(\w+)Handler/;

  $callback = lc $callback;

  $r->notes->add($callback => 'Perl');

  $r->log->info("ran $callback from Perl for ", $r->args || '(null)');

  return Apache::DECLINED;
}

1;
