use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

plan tests => 1, have_lwp;

my $uri = "/index.html";

t_debug("uri: $uri");

my $response = GET $uri;

my $received = $response->content;

# because we hook after core, our REALLY_LAST comes
# before core's REALLY_LAST for trans and maptostorage,
# even though both trans and maptostorage are RUN_FIRST
#
# mod_mime's type handler is MIDDLE, so it prevents our
# Perl REALLY_LAST and LAST hooks from running

my $expected = <<EOF;
postreadrequest: C, Perl
trans: C, Perl
maptostorage: C, Perl
headerparser: C, Perl
access: C, Perl
type: C
fixup: C, Perl
EOF

ok t_cmp($expected,
         $received,
         'mod_perl is last');
