use strict;
use warnings FATAL => 'all';

use Apache2 ();
use Apache::ServerRec ();
use Apache::ServerUtil ();
use Apache::Process ();
use Apache::RequestRec ();
use Apache::RequestIO ();
use Apache::Const -compile => ':common';

test_add_config();

sub test_add_config {
    my $conf = <<'EOC';
PerlModule Apache::TestHandler
<Location /apache/add_config>
  SetHandler perl-script
  PerlResponseHandler Apache::TestHandler::ok1
</Location>
EOC
    Apache->server->add_config([split /\n/, $conf]);

    Apache->server->add_config(['<Perl >', '1;', '</Perl>']);
}

1;
