import markdown2
import sys

def main(content_path, template_path):
    md = markdown2.Markdown()

    lines = open(content_path).readlines()
    title = None

    for line in lines:
        if line.startswith("# "):
            title = line[2:]
            break

    body = "".join(lines)
    body = md.convert(body)

    page = open(template_path).read()

    page = page.replace("@title@", title)
    page = page.replace("@body@", body)

    sys.stdout.write(page)

if __name__ == "__main__":
    main(*sys.argv[1:])
