package it.test.route;

import org.apache.servicemix.jbi.listener.MessageExchangeListener;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.bean.Operation;

import javax.annotation.Resource;
import javax.annotation.PreDestroy;
import javax.annotation.PostConstruct;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.MessageExchange.Role;
import javax.xml.transform.Source;

import org.apache.log4j.Logger;

/**
 */
public class TestBean
  implements MessageExchangeListener {

    private static Logger log = Logger.getLogger(TestBean.class);

    @Resource
    private DeliveryChannel channel;

    @PostConstruct
    public void init()
    {
    }

    @Operation(name = "sendQuery")
    public void onMessageExchange(MessageExchange exchange)
      throws MessagingException
    {
      if (exchange == null) {
        log.error("Received an invalid exchange message");
        return;
      }

      // The component acts as a consumer, this means this exchange
      // is received because we sent it to another component.
      // As it is active, this is either an out or a fault
      // If this component does not create / send exchanges,
      // you may just throw an UnsupportedOperationException
      if (exchange.getRole() == Role.CONSUMER)
        onConsumerExchange(exchange);
      // The component acts as a provider, this means that another
      // component has requested our service
      // As this exchange is active, this is either an in or
      // a fault (out are send by this component)
      else if (exchange.getRole() == MessageExchange.Role.PROVIDER)
        onProviderExchange(exchange);
      // Unknown role
      else
        throw new MessagingException("TestBean.onMessageExchange(): " +
                                     "Unknown role: " + exchange.getRole());

    }

    /**
     * Handle the incoming consumer messages
     * @param exchange
     * @throws MessagingException
     */
    private void onConsumerExchange (MessageExchange exchange)
      throws MessagingException
    {
      // Out message
      if (exchange.getMessage("out") != null) {
        exchange.setStatus(ExchangeStatus.DONE);
        channel.send(exchange);
      }
      // Fault message
      else if (exchange.getFault() != null) {
        exchange.setStatus(ExchangeStatus.DONE);
        channel.send(exchange);
      }
      // This is not compliant with the default MEPs
      else {
        throw new MessagingException("TestBean.onConsumerExchange(): Consumer " +
                                     "exchange is ACTIVE, but no out or fault is provided");
      }

    }

    /**
     * Handle the incoming provider messages
     * @param exchange
     * @throws MessagingException
     */
    private void onProviderExchange (MessageExchange exchange)
      throws MessagingException
    {
      NormalizedMessage in = null, out = null;
      String body = null, xml_resp = null;
      Source content = null;

      // Exchange is finished
      if (exchange.getStatus() == ExchangeStatus.DONE) {
        return;
      }
      // Exchange has been aborted with an exception
      else if (exchange.getStatus() == ExchangeStatus.ERROR) {
        return;
      }
      // Fault message
      else if (exchange.getFault() != null) {
        exchange.setStatus(ExchangeStatus.DONE);
        channel.send(exchange);
      }
      else {
        in = exchange.getMessage("in");

        if (in == null)
          // no in message - strange
          throw new MessagingException("TestBean.onProviderExchange():" +
                                       " Exchange has no IN message");

        content = in.getContent();

        try {
          log.debug("Received message ...");
          //process content according to your logic
          body = (new SourceTransformer()).toString(content);
          out = exchange.createMessage();
          out.setContent(new StringSource("ANSWER"));

          Thread.sleep(4000);
          // Set response
          /*exchange.setStatus(ExchangeStatus.DONE);*/
          exchange.setMessage(out, "out");
          channel.send(exchange);

        } catch (Throwable ex) {

          ex.printStackTrace();
          throw new MessagingException("TestBean.onProviderExchange():" +
                                       " Error on handle request " +
                                       ex.getMessage());

        }

      } // end else


    }

    @PreDestroy
    public void destroy ()
    {
    }
}

