package it.route.test;

import org.apache.camel.Exchange;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Property;
import org.apache.camel.ExchangePattern;

import org.apache.log4j.Logger;

import java.util.Set;
import java.util.Map;

public class CallerBean {

    private final static Logger log = Logger.getLogger(CallerBean.class);

    public final static String uriProp = "uri";

    public void sendNotify (Exchange exchange,
                            @Property(uriProp) String notifUri)
        throws Exception
    {
        Endpoint tEndpoint = null;
        ProducerTemplate template = null;
        Message out = null, in = null;
        Exchange e = null;
        Map<String, Object> properties = null;
        Set<String> keys = null;


        if (notifUri == null)
          throw new Exception(uriProp + " property not found");

        try {

            log.info("Send notify to: " + notifUri);

            tEndpoint = exchange.getContext().getEndpoint(notifUri);

            e = exchange.copy();

            if (notifUri.indexOf("mep") > 0) {
                if (notifUri.indexOf("robust-in-only") > 0)
                    e.setPattern(ExchangePattern.RobustInOnly);
                else if (notifUri.indexOf("robust-out-only") > 0)
                    e.setPattern(ExchangePattern.RobustOutOnly);
                else if (notifUri.indexOf("in-out") > 0)
                    e.setPattern(ExchangePattern.InOut);
                else if (notifUri.indexOf("in-only") > 0)
                    e.setPattern(ExchangePattern.InOnly);
                else
                    throw new Exception("Mep not implemented");
            } else {

              log.debug("Use in-out MEP as default");
              e.setPattern(ExchangePattern.InOut);

            }

            template = e.getContext().createProducerTemplate();
            template.send(tEndpoint, e);
            template.stop();

            log.info("Completed notify to: " + notifUri);

            properties = e.getProperties();
            keys = properties.keySet();

            for (String propertyName : keys) {

                if (!propertyName.equals("org.apache.servicemix.correlationId") &&
                    !propertyName.equals("CamelToEndpoint") &&
                    !propertyName.equals("CamelFailureHandled") &&
                    !propertyName.equals("CamelExceptionCaught") &&
                    !propertyName.equals("CamelFailureEndpoint") &&
                    !propertyName.equals("CamelErrorHandlerHandled") &&
                    !propertyName.equals("CamelCorrelationId") &&
                    !propertyName.equals("CamelBeanMethodName") &&
                    !propertyName.equals("CamelRouteStop") &&
                    !propertyName.equals("org.apache.servicemix.senderEndpoint") &&
                    !propertyName.equals("javax.jbi.ServiceEndpoint") &&
                    !propertyName.equals("javax.jbi.servicedesc.ServiceEndpoint") &&
                    !propertyName.equals("javax.jbi.ServiceName") &&
                    !propertyName.equals("javax.jbi.InterfaceName") &&
                    !propertyName.equals("javax.jbi.messaging.sendSync") &&
                    !propertyName.equals("javax.jbi.messaging.MessageExchange") &&
                    !propertyName.equals("javax.jbi.transaction.jta")) {

                    // get the property value
                    Object propertyValue = properties.get(propertyName);
                    log.info("Copy property ==> " + propertyName + " = " + propertyValue);

                    // set the property in the camel exchange
                    exchange.setProperty(propertyName, propertyValue);

                }

            } // end for

            // Remove properties
            exchange.removeProperty(uriProp);

        } catch (Throwable exc) {

            log.error(exc.getMessage());
            throw new Exception(exc.getMessage());
        }
    }

}
