package it.route.test;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.interceptor.DefaultTraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;

import org.apache.log4j.Logger;

import org.springframework.beans.factory.annotation.Required;

import static it.route.test.CallerBean.*;
/**
 *
 * This class defines the main Camel route for handle send diagnostic request
 * to device
 */
public class TestRouteRoute2
        extends RouteBuilder {

    private static final Logger log = Logger.getLogger(TestRouteRoute2.class);

    /**
     * Lets configure the Camel routing rules using Java code...
     */
    public void configure()
        throws Exception
    {
        CallerBean callerBean = new CallerBean();
        Tracer tracer = new Tracer();
        tracer.setTraceOutExchanges(true);
        tracer.setLogStackTrace(true);
        // we configure the default trace formatter where we can
        // specify which fields we want in the output
        DefaultTraceFormatter formatter = new DefaultTraceFormatter();
        formatter.setShowOutBody(true);
        formatter.setShowOutBodyType(true);
        // set to use our formatter
        tracer.setFormatter(formatter);
        getContext().addInterceptStrategy(tracer);

        // Set shutdown timeout to 10sec
        getContext().getShutdownStrategy().setTimeout(10);

        // --------------------------------------------------------------------
        // Main route
        // --------------------------------------------------------------------
        from("jbi:endpoint:" + "http://it.route.test/test/" +
             "TestRouteRoute2" + "/" +
             "TestRoute2Endpoint1")

            // Initialize SqlCamel bean fixed properties
            .setProperty("Source", constant("TestRouteRoute2"))

            // Set error Handler
            .errorHandler(deadLetterChannel("direct:processERROR"))

            .to("direct:handleRequest")

        ; // end route

        from("direct:handleRequest")

            .log("RECEIVE CALL SERVICE")

            .log("CALL JBI SERVICE")

            .setProperty(uriProp,
                         constant("jbi:service:" +
                                  "http://test.route.it/test" + "/" +
                                  "testBeanService" + "?mep=in-out"))

            .bean(callerBean, "sendNotify")

            .log("AFTER CALL SERVICE")

            .log("RETURN TO CALLER") 
        ; // end route

        // --------------------------------------------------------------------
        // Unexpected error on handle request
        // --------------------------------------------------------------------
        from("direct:processERROR")

            // Remove source property
            .removeProperty("Source")

            .log("ERRRORORORORO")


        ; // end route

    } // end configure

} // end BackendRouteBuilder
