package com.kmslh.web.studio.source.impl;

import org.apache.tika.sax.ToHTMLContentHandler;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Scope(value = BeanDefinition.SCOPE_PROTOTYPE)
@Component
public class MyContentHandler extends ToHTMLContentHandler {

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!localName.equals("img") || !atts.getValue("src").startsWith("embedded")) {
            super.startElement(uri, localName, qName, atts);
        }
    }
}
