package com.kmslh.web.studio.source.impl;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.ImageParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class MyImageParser extends ImageParser {
    private static Map<String, String> images = new HashMap<String, String>();

    public static String getImage(String name) {
        return images.get(name);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy(stream, baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        String dataUri = getDataUrl(metadata.get(Metadata.CONTENT_TYPE), baos.toByteArray());
        metadata.set("dataUri", dataUri);
        images.put(metadata.get(Metadata.RESOURCE_NAME_KEY), dataUri);

        super.parse(bais, handler, metadata, context);
    }

    private String getDataUrl(String type, byte [] bytes) {
        String base64 = Base64.encodeBase64String(bytes);
        return "data:" + type + ";base64," + base64;
    }
}
