cdef extern from "prayer.h":
    ctypedef struct Date:
        int day
        int month
        int year

    ctypedef struct Location:
        double degreeLat
        double degreeLong
        double gmtDiff
        double pressure
        double seaLevel
        double temperature
        int dst

    ctypedef struct Method:
        pass

    ctypedef struct Prayer:
        int hour
        int isExtreme
        int minute
        int second

    void getMethod(int n, Method* conf)

    void getImsaak (Location*, Method*, Date*, Prayer*)
    void getNextDayFajr (Location*, Method*, Date*, Prayer*)
    void getNextDayImsaak (Location*, Method*, Date*, Prayer*)
    void getPrayerTimes (Location*, Method*, Date*, Prayer*)		    

    void decimal2Dms (double decimal, int *deg, int *min, int *sec)
    double getNorthQibla(Location* location)

   
def dec2dms(dec):
    #!cdef int deg, min, sec  # helmi: sec should be as double
    cdef int deg, min
    cdef double sec
    decimal2Dms(dec, &deg, &min, &sec)
    return deg, min, sec


cdef Date dat
cdef Location loc
cdef Method conf

class Solat:
    def __init__(self, date=None, latitude=21.4206, longitude=39.8304, 
	         utcdiff=3, method=6, extreme=0, round=0, sea=0, dst=0, city="Makkah"):
        """Constructor.
        
        Default value is for Makkah city.
        date = yyyymmdd
        """
        if date is None:
            import time
            date = time.strftime("%Y%m%d", time.gmtime())
        dat.year = int(date[:4])
        dat.month = int(date[4:6])
        dat.day = int(date[6:])

        loc.degreeLat = latitude
        loc.degreeLong = longitude
        loc.gmtDiff = utcdiff
        loc.seaLevel = sea
        loc.dst = dst
        getMethod(method, &conf)
        self.city = city
        self.date = "%s-%s-%s" % (dat.year, dat.month, dat.day)

    def times(self):
        cdef Prayer pp[6]
        getPrayerTimes(&loc, &conf, &dat, pp)
        m = []
        for i from 0 <= i < 6:
            m.append((pp[i].hour, pp[i].minute, pp[i].second, pp[i].isExtreme))
        return m

    def imsaak(self):
        cdef Prayer imsaak
        getImsaak(&loc, &conf, &dat, &imsaak)
        return imsaak.hour, imsaak.minute, imsaak.second, imsaak.isExtreme

    def nextImsaak(self):
        cdef Prayer imsaak
        getNextDayImsaak(&loc, &conf, &dat, &imsaak)
        return imsaak.hour, imsaak.minute, imsaak.second, imsaak.isExtreme

    def nextFajr(self):
        cdef Prayer fajr
        getNextDayFajr(&loc, &conf, &dat, &fajr)
        return fajr.hour, fajr.minute, fajr.second, fajr.isExtreme

    def northQibla(self):
        return getNorthQibla(&loc)
