#!/usr/bin/env python
import solat


def loc(name, val):
    """FIXME: sec give wrong value"""
    symb = chr(0xb0)
    deg, min, sec = solat.dec2dms(val)
    if val >= 0: 
        dtn = 'W'
    else: 
        dtn = 'E'
    dtn = "of true %s" % dtn
    return "%s \t: %03d%s %02d' %02.2f\" %s of true North" % (name, abs(deg), symb, 
                                           abs(min), abs(sec), dtn)


# http://www.heavens-above.com/Neighbours.asp?PlaceID=1524576&lat=0&lng=0&alt=0&loc=Unspecified&TZ=CET
dk = solat.Solat(latitude=3.167, longitude=101.733, 
                 method=1, utcdiff=8, sea=69, city="Kampong Datok Keramat")
kl = solat.Solat(latitude=3.167, longitude=101.700, 
                 method=1, utcdiff=8, sea=64, city="Kuala Lumpur")
default = solat.Solat()
# st = default
st = dk
# st = kl

print "Prayer schedule for: %s on %s" % (st.city, st.date)
print loc('Qibla', st.northQibla())
print

snames = "Fajr", "Shuruq", "Zuhr", "Asr", "Maghrib", "Ishaa"
for sname, pt in zip(snames, st.times()):
    print sname, '= %2d:%02d' % pt[:2]

print
print "Tomorrow's Fajr = %2d:%02d" % st.nextFajr()[:2]
print "Tomorrow's Imsaak = %2d:%02d" % st.nextImsaak()[:2]
print "Today's Imsaak = %2d:%02d" % st.imsaak()[:2]


