import QtQuick 2.0

import QtQuick.Controls 1.0
import QtQuick.PresentForJens 1.0

Rectangle {
    id: top
    width:  1200
    height: 700

    color: "#fafac8" //250, 250, 200

    Text {
        id: centreText
        text: qsTr("Welcome to the future!")
        y: 100
        z: 10
        anchors.horizontalCenter: parent.horizontalCenter
        font.pixelSize: 36
    }


    Rectangle {
        id: bullet
        width: cannon.calibre
        height: cannon.calibre
        radius: width / 2
        property double time: 0
        property double vx: 0
        property double vy: 0
        property double x0:0
        property double y0:0
        property double a: -9.81
        x: x0 + time * vx
        y: y0 + time * vy - time*time*a/2
        z: 1
        color: "black"

        visible: false

        onXChanged: {
            if (target.hit()) {
                //console.log("HIT");
                visible = false;
                bulletTime.running = false;
                score.intValue = score.intValue + 1;
                target.randomize();
            } else if (barrier.hit()) {
                visible = false;
                bulletTime.running = false;
            }
        }

        NumberAnimation {
            id: bulletTime
            target: bullet
            properties: "time"
            from: 0
            to: 100.0
            duration: 10 * 1000
            running: false
        }
    }

    Target {
        id: barrier
        width: 50
        height: 300
        x: 600
        color: "yellow"

        anchors.bottom: cannon.bottom
    }

    Item {
        id: targetField
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.left: barrier.right
        anchors.right: parent.right
        Target {
            id: target
            Component.onCompleted: randomize()
        }
    }

    Item {
        id: cannon
        anchors.left: counters.right
        anchors.bottom: parent.bottom
        anchors.margins: 10
        height: 300
        width: 300
        property double elevation: 45 // 0..90
        property double force: 100
        property double calibre: height/8
        clip: true

        Rectangle {
            id: cbase
            color: "blue"
            anchors.verticalCenter: parent.bottom
            anchors.horizontalCenter: parent.left
            width: parent.width
            height: width
            radius: width / 2
        }
        Rectangle {
            id: barrel
            x: height / 2
            y: parent.height - height

            width: parent.width * 0.7
            height: cannon.calibre
            color: "blue"
            transformOrigin: Item.Left
            rotation: -cannon.elevation
            LCDNumber {
                height: parent.height * 2
                width: height * 2
                digitCount: 4
                intValue: cannon.force
                y: (cannon.elevation - 90)/90 * parent.height
                anchors.right: parent.right
            }
        }

        LCDNumber {
            height: cannon.calibre * 2
            width: height
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.margins: 10
            digitCount: 2
            intValue: cannon.elevation
        }

	function baseHit(mouse) {
	    var y  = cannon.height - mouse.y;
	    var x = mouse.x;
	    var r = cannon.width/2;
	    return x*x + y*y < r*r;
	}

	function shoot() {
            bullets.intValue = bullets.intValue + 1;
            bulletTime.running = false;
            var pos = barrel.mapToItem(top, barrel.width, barrel.height/2);

            bullet.x0 = pos.x - bullet.width/2
            bullet.y0 = pos.y - bullet.height/2
            bullet.vy = -cannon.force * Math.sin(cannon.elevation/180*Math.PI)
            bullet.vx = cannon.force * Math.cos(cannon.elevation/180*Math.PI)

            bullet.visible = true
            bulletTime.running = true
	}

	MouseArea {
            id: mouser
	    anchors.fill: parent

	    property bool basePressed: false;
            onWheel: {
		cannon.force += wheel.angleDelta.y / 120;
            }
	    onPressed: {
		basePressed = cannon.baseHit(mouse);
	    }
	    onPositionChanged: {
		console.log("move "+mouse.x+", "+mouse.y+" ..."+basePressed);
		if (!basePressed && mouse.x > 0 && mouse.y < height) {
		    cannon.elevation = Math.atan2(height-mouse.y, mouse.x)*180/Math.PI;
		}
	    }
	    onReleased: {
		if (basePressed && cannon.baseHit(mouse))
		    cannon.shoot();
	    }
        }
    }


    PinchArea {
        id: cannoncontrol
        anchors.fill: parent
        property double startForce: 100
        onPinchStarted: startForce = cannon.force
        onPinchUpdated: {
            if (pinch.angle >= 0 && pinch.angle <= 90) {
                cannon.elevation = pinch.angle;
            } else if  (pinch.angle >= -180 && pinch.angle <= -90) {
                cannon.elevation = pinch.angle + 180;
            }
            if (pinch.scale * startForce < 200)
                cannon.force = pinch.scale * startForce
        }
    }

    Column {
        id: counters
        anchors.left: parent.left
        anchors.top: parent.top
        //anchors.bottom: parent.bottom
        anchors.margins: 20
        spacing: 10

        Text {
            text: "Bullets:"
            font.pixelSize: 36
        }

        LCDNumber {
            width: 100
            height: 100
            id: bullets
            intValue: 0
            digitCount: 2
        }

        Text {
            text: "Score:"
            font.pixelSize: 36
        }

        LCDNumber {
            height: 100
            width: 100
            id: score
            intValue: 0
            digitCount: 2
        }
    }

    Column {
        id: buttons
        anchors.left: parent.left
        anchors.bottom: parent.bottom
        anchors.margins: 20
        spacing: 40

        Button {
            styleHints: "big"
            text: "Shoot"
            onClicked: {
		cannon.shoot();
            }
        }


	Button {
            styleHints: "big"
            text: "Quit"
            onClicked: {
		Qt.quit();
            }
	    
	}
    }
}
