
import QtQuick 2.1
import QtTest 1.0
import "../../src/qml" as MyControls

TestCase {
    id: testCase
    name: "Tests_MyRectangle"
    when: windowShown
    width: 200
    height: 200

    MyControls.MyRectangle {
        id: myRect
    }
    function test_color1() {
        compare(myRect.isRed, false)
        compare(myRect.color, "#008000")
        myRect.isRed = true
        compare(myRect.isRed, true)
        compare(myRect.color, "#ff0000")
    }
    function test_color2() {
        var component = Qt.createComponent("../../src/qml/MyRectangle.qml");
        compare(component.status, Component.Ready)
        var myrect =  component.createObject(testCase);
        compare(myrect.isRed, false)
        compare(myrect.color, "#008000")
        myrect.isRed = true
        compare(myrect.isRed, true)
        compare(myrect.color, "#ff0000")
        myrect.destroy()
    }
}
