package org.apache.devicemapweb.controller;
 
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.beans.factory.annotation.Autowired;

import org.apache.devicemapweb.model.UserAgentReview;
import org.apache.devicemapweb.dao.UserAgentReviewDAO;
 
@Controller
@RequestMapping("/review")
public class Review
{
    private static final Logger log = Logger.getLogger(Review.class);

    @Autowired
    private UserAgentReviewDAO userAgentReviewDAO;

    @RequestMapping(method=RequestMethod.GET)
    public String root(ModelMap model)
    {
        log.debug("root() called, redirecting to /");

        return "redirect:/review/";
    }

    @RequestMapping(value="/",method=RequestMethod.GET)
    public String showReviews(ModelMap model)
    {
        log.debug("showReviews() called");

        model.addAttribute("agents",userAgentReviewDAO.getAll());

        return "show";
    }

    @RequestMapping(value="/add",method=RequestMethod.POST)
    public String addReviews(@ModelAttribute UserAgentReview userAgentReview,ModelMap model)
    {
        log.debug("addReview() called: "+userAgentReview.getUserAgent());

        userAgentReviewDAO.add(userAgentReview);

        return showReviews(model);
    }
}
