package org.apache.devicemapweb.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.apache.devicemapweb.model.UserAgentReview;

public class UserAgentReviewDAO
{
    @PersistenceContext
    private EntityManager manager;


    @Transactional
    public void add(UserAgentReview uar)
    {
        getManager().persist(uar);
    }

    @Transactional
    public UserAgentReview get(Long id)
    {
        return getManager().find(UserAgentReview.class,id);
    }

    @Transactional
    public List<UserAgentReview> getAll()
    {
        Criteria criteria = getSession().createCriteria(UserAgentReview.class);
        return criteria.list();
    }

    @Transactional
    public void update(UserAgentReview uar)
    {
        getManager().merge(uar);
    }

    @Transactional
    public void delete(UserAgentReview uar)
    {
        getManager().remove(uar);
    }


    public Session getSession()
    {
        return ((Session)getManager().getDelegate());
    }

    public EntityManager getManager()
    {
        return manager;
    }
}
