package freenet.message.client;

import freenet.*;
import freenet.node.State;
import freenet.node.states.FCP.*;

/** This is for the FCP handshake.
  */
public class ClientLoad extends ClientMessage {

    public static final String messageName = "ClientLoad";

    public ClientLoad(ConnectionHandler source, RawMessage raw) {
        super(source, raw);
    }

    public State getInitialState() {
        return formatError
            ? (State) new NewIllegal(id, source, "Error parsing ClientLoad message.")
            : (State) new NewLoad(id, source);
    }

    public String getMessageName() {
        return messageName;
    }
}
