package freenet.node.states.FCP;

import freenet.*;
import freenet.node.*;
import freenet.support.*;
import freenet.support.io.*;
import freenet.message.client.*;

public class NewLoad extends NewClientRequest {

    public NewLoad(long id, ConnectionHandler source) {
        super(id, source);
    }
    
    public final String getName() {
        return "New Client Load";
    }

    public State received(Node n, MessageObject mo) throws BadStateException {
        if (!(mo instanceof ClientLoad))
            throw new BadStateException("expecting ClientLoad");
        FieldSet fs = new FieldSet();
	fs.add("EstimatedLoad", Fields.longToString((long)(n.estimatedLoad() * 100)));
        sendMessage(new NodeLoad(id, fs));
        return null;
    }
}

