package org.xwiki.xmlrpc;

import java.util.Date;
import java.util.Map;

public class Page extends PageSummary
{
    @Property
    protected Integer version;

    @Property
    protected String content;

    @Property
    protected Date created;

    @Property
    protected String creator;

    @Property
    protected Date modified;

    @Property
    protected String modifier;

    @Property
    protected Boolean homePage;

    @Property
    protected String currentStatus;

    @Property
    protected Boolean current;
    
    protected String name;

    public Page(String id, String space, String parentId, String title, String content) {
        this(id, space, parentId, title, "", 0, 0, content, new Date(), "", new Date(), "", false, "", true);        
    }
    
    public Page(String id, String space, String parentId, String title, String url,
        Integer permissions, Integer version, String content, Date created, String creator,
        Date modified, String modifier, Boolean homePage, String currentStatus, Boolean current)
    {
        super(id, space, parentId, title, url, permissions);
        this.version = version;
        this.content = content;
        this.created = created;
        this.creator = creator;
        this.modified = modified;
        this.modifier = modifier;
        this.homePage = homePage;
        this.currentStatus = currentStatus;
        this.current = current;               
    }    

    public Page(Map<String, Object> map)
    {
        super(map);        
    }
           
    public Integer getVersion()
    {
        return version;
    }

    public String getContent()
    {
        return content;
    }

    public Date getCreated()
    {
        return created;
    }

    public String getCreator()
    {
        return creator;
    }

    public Date getModified()
    {
        return modified;
    }

    public String getModifier()
    {
        return modifier;
    }

    public Boolean getHomePage()
    {
        return homePage;
    }

    public String getCurrentStatus()
    {
        return currentStatus;
    }

    public Boolean getCurrent()
    {
        return current;
    }

    public void setContent(String content)
    {
        this.content = content;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }

    public String getName()
    {
        if(name == null) {
            if(id.indexOf('.') != -1) {
                name = id.split("\\.")[1];
            }
            else {
                name = id;
            }
        }
        
        return name;
    }
    
    
}
