package org.xwiki.xmlrpc;

import java.util.Map;

public class PageSummary extends MapObject
{
    @Property
    protected String id;

    @Property
    protected String space;

    @Property
    protected String parentId;

    @Property
    protected String title;
    
    @Property
    protected String url;
    
    @Property
    protected Integer permissions;

    public PageSummary(String id, String space, String parentId, String title, String url, Integer permissions)
    {
        if(id == null) {
            throw new IllegalArgumentException("Page id must not be null");
        }
        
        this.id = id;
        this.space = space;
        this.parentId = parentId;
        this.title = title;
        this.url = url;
        this.permissions = permissions;
    }

    public PageSummary(Map<String, Object> map)
    {
        super(map);        
    }
    
    
    public String getId()
    {
        return id;
    }

    public String getSpace()
    {
        if(id.indexOf('.') != -1) {
            space = id.split("\\.")[0];
        }
        
        return space;
    }

    public String getParentId()
    {
        return parentId;
    }

    public String getTitle()
    {
        return title;
    }

    public String getUrl()
    {
        return url;
    }

    public Integer getPermissions()
    {
        return permissions;
    }
}
