package org.xwiki.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class XWikiXmlRpcClient
{
    private XmlRpcClient xmlRpcClient;

    private String token;

    private String rpcHandler;

    public XWikiXmlRpcClient(String endpoint) throws MalformedURLException
    {
        this(endpoint, "confluence1");
    }

    public XWikiXmlRpcClient(String endpoint, String rpcHandler) throws MalformedURLException
    {
        XmlRpcClientConfigImpl clientConfig = new XmlRpcClientConfigImpl();
        clientConfig.setServerURL(new URL(endpoint));

        xmlRpcClient = new XmlRpcClient();
        xmlRpcClient.setConfig(clientConfig);

        this.rpcHandler = rpcHandler;

        token = "";
    }
    
    public void login(String username, String password) throws XmlRpcException
    {
        token = (String) invokeRpc("login", username, password);
    }

    public boolean logout() throws XmlRpcException
    {
        Boolean value = (Boolean) invokeRpc("logout", token);
        token = "";

        return value.booleanValue();
    }
    
    public List<SpaceSummary> getSpaces() throws XmlRpcException
    {
        Object[] objects = (Object[]) invokeRpc("getSpaces", token);
        List<SpaceSummary> result = new ArrayList<SpaceSummary>();
        for(Object object : objects) {
            Map<String, Object> spaceSummaryMap = (Map<String, Object>) object;
            SpaceSummary spaceSummary = new SpaceSummary(spaceSummaryMap);
            result.add(spaceSummary);
        }
        
        return result;
    }
    
    public Space getSpace(String spaceName) throws XmlRpcException {
        Object object = invokeRpc("getSpace", token, spaceName);        
        return new Space((Map<String, Object>)object);
    }
    
    public List<PageSummary> getPages(String spaceName) throws XmlRpcException
    {
        Object[] objects = (Object[]) invokeRpc("getPages", token, spaceName);
        List<PageSummary> result = new ArrayList<PageSummary>();
        for(Object object : objects) {
            Map<String, Object> pageSummaryMap = (Map<String, Object>) object;
            PageSummary pageSummary = new PageSummary(pageSummaryMap);
            result.add(pageSummary);
        }
        
        return result;
    }
    
    public Page getPage(String pageId) throws XmlRpcException {
        Object object = invokeRpc("getPage", token, pageId);
        return new Page((Map<String, Object>)object);
    }

    public Page storePage(Page page) throws XmlRpcException {
        Object object = invokeRpc("storePage", token, page.toMap());
        return new Page((Map<String, Object>)object);
    }
    
    public List<XWikiObject> getObjects(String pageId) throws XmlRpcException {
        Object[] objects = (Object[])invokeRpc("getObjects", token, pageId);
        List<XWikiObject> result = new ArrayList<XWikiObject>();
        for(Object object : objects) {
            Map<String, Object> xwikiObjectMap = (Map<String, Object>) object;
            XWikiObject xwikiObject = new XWikiObject(xwikiObjectMap);
            result.add(xwikiObject);
        }
        
        return result;
    }
    
    public Object storeObject(XWikiObject xwikiObject) throws XmlRpcException {
        Object object = invokeRpc("storeObject", token, xwikiObject.toMap());
        return new XWikiObject((Map<String, Object>)object);
    }
    
    public Object[] getClasses() throws XmlRpcException {
        Object[] objects = (Object[])invokeRpc("getClasses", token);
        
        return null;
    }
    

    
    public Object invokeRpc(String methodName, Object... args) throws XmlRpcException
    {
        return xmlRpcClient.execute(String.format("%s.%s", rpcHandler, methodName), args);
    }
}
