/* AADL plugin for DIA
*
* Copyright (C) 2005 Laboratoire d'Informatique de Paris 6
* Author: Pierre Duquesne
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>
#include <math.h>
#include <string.h>

#include "intl.h"
#include "object.h"
#include "connection.h"
#include "connectionpoint.h"
#include "diarenderer.h"
#include "attributes.h"
#include "widgets.h"
#include "arrows.h"
#include "connpoint_line.h"
#include "element.h"
#include "text.h"
#include "properties.h"

#include "tool-icons.h"

/***********************************************
 **              CONSTANTS                    **
 ***********************************************/

#define DEFAULT_WIDTH 0.25

/***********************************************
 **                 TYPES	                  **
 ***********************************************/

typedef struct _LineProperties LineProperties;

typedef struct _PortLine {
  Connection connection;

  ConnPointLine *cpl;

  Color line_color;
  real line_width;
  LineStyle line_style;  
  Arrow start_arrow, end_arrow;
  real dashlength;
  real absolute_start_gap, absolute_end_gap;
} PortLine;

/***********************************************
 **                 FUNCTIONS                 **
 ***********************************************/

struct _LineProperties {
  real absolute_start_gap, absolute_end_gap;
};

static LineProperties default_properties;

static ObjectChange* line_move_handle(PortLine *line, Handle *handle,
				      Point *to, ConnectionPoint *cp,
				      HandleMoveReason reason, 
			     ModifierKeys modifiers);
static ObjectChange* line_move(PortLine *line, Point *to);
static void line_select(PortLine *line, Point *clicked_point,
			DiaRenderer *interactive_renderer);
static void line_draw(PortLine *line, DiaRenderer *renderer);
static DiaObject *line_create(Point *startpoint,
			   void *user_data,
			   Handle **handle1,
			   Handle **handle2);
static real line_distance_from(PortLine *line, Point *point);
static void line_update_data(PortLine *line);
static void line_destroy(PortLine *line);
static DiaObject *line_copy(PortLine *line);

static PropDescription *line_describe_props(PortLine *line);
static void line_get_props(PortLine *line, GPtrArray *props);
static void line_set_props(PortLine *line, GPtrArray *props);

static void line_save(PortLine *line, ObjectNode obj_node, const char *filename);
static DiaObject *line_load(ObjectNode obj_node, int version, const char *filename);
static DiaMenu *line_get_object_menu(PortLine *line, Point *clickedpoint);

void Line_adjust_for_absolute_gap(PortLine *line, Point *gap_endpoints);

static PropNumData gap_range = { -G_MAXFLOAT, G_MAXFLOAT, 0.1};