﻿module main;

import std.stdio;
import std.string;
import std.range;
import std.algorithm;
import std.conv;
import rarray;

void f(in size_t[2]...){}

void main(string[] argv)
{
	f(0,-2);
	auto var = RArray!(string, 2)(5, 3);
	
	writeln("Initialization");
	writeln();
	
	var[] = map!`to!string(a)`(iota(1, 16));
	writeln(var);
	
	int n = 0;
	foreach(ref el; var)
		el = to!string(n+=2);
	writeln(var);
	
	foreach(i, j, ref el; var)
		el = format("%s-%s", i, j);
	writeln(var);
	
	foreach(i; 0 .. var.lengths[0])
		foreach(j; 0 .. var.lengths[1])
			var[i, j] = format("%s+%s", i, j);
	writeln(var);
	
	writeln("----------");
	writeln("Getting an element");
	writeln();
	
	writeln(var.opIndex!()(0, 0));
	writeln(var[0, 0]);
	writeln(var[4, 2]);
	writeln();
	
	writeln("----------");
	writeln("Getting sub rarray with same dimensions");
	writeln();
	
	writeln(var[R[0 .. 2], R[0 .. 2]]);
	writeln(var[R[1 .. 3], R[1 .. 3]]);
	writeln(var[R[1 .. 3], R[2 .. 3]]);
	writeln(var[R[], R[3 .. 3]]);
	
	writeln("----------");
	writeln("Getting sub rarray with less dimensions");
	writeln();
	
	writeln(var[0, R[]]);
	writeln(var[1, R[]]);
	writeln(var[2, R[]]);
	writeln(var[3, R[1..3]]);
	writeln(var[4, R[0..2]]);
	writeln(var[R[], 0]);
	writeln(var[R[1..5], 1]);
	writeln(var[R[0..4], 2]);
	
	writeln("----------");
	writeln("Assigning to sub rarray");
	writeln();
	
	var[0, R[]] = ["x", "y", "z"];
	writeln(var);
	var[R[], 0] = var[R[], 2] = ["a", "b", "c", "d", "e"];
	writeln(var);
	var[R[1..3], R[1..3]] = ["W", "X", "Y", "Z"];
	writeln(var);
	
	writeln("----------");
	writeln("Mapping indices");
	writeln();
	
	writeln(var.mapIndices!`a, a`);
	writeln(var.mapIndices!`2*a, 3-1-a`);
	writeln();
	auto bigVar = RArray!(string, 2)(30, 20);
	foreach(ref el; bigVar.mapIndices!`a, a`)
		el = "X";
	foreach(ref el; bigVar.mapIndices!`a^^2 / 5, a`())
		el = "Y";
	writeln(bigVar);
	
	writeln("----------");
	writeln("3D examples");
	writeln();
	auto var3d = RArray!(string, 3)(2, 3, 4);
	foreach(i, j, k, ref el; var3d)
		el = format("%s-%s-%s", i, j, k);
	writeln(var3d);
	writeln(var3d[1, 1, 1]);
	writeln(var3d[R[], R[1..3], R[2..4]]);
	writeln(var3d[1, R[1..3], R[2..4]]);
	writeln(var3d[R[], 1, R[2..4]]);
	writeln(var3d[1, 1, R[2..4]]);
	
	readln();
}
