/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2004  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org> and
              Ville Syrjl <syrjala@sci.fi>.

   This file is subject to the terms and conditions of the MIT License:

   Permission is hereby granted, free of charge, to any person
   obtaining a copy of this software and associated documentation
   files (the "Software"), to deal in the Software without restriction,
   including without limitation the rights to use, copy, modify, merge,
   publish, distribute, sublicense, and/or sell copies of the Software,
   and to permit persons to whom the Software is furnished to do so,
   subject to the following conditions:

   The above copyright notice and this permission notice shall be
   included in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


#include <stdio.h>
#include <unistd.h>

#include <sys/file.h>

#include <pthread.h>

#include <direct/clock.h>

#include <fusion/build.h>
#include <fusion/fusion.h>
#include <fusion/lock.h>
#include <fusion/property.h>
#include <fusion/reactor.h>
#include <fusion/ref.h>
#include <fusion/shmalloc.h>
#include <fusion/hash.h>
#include <fusion/object.h>

#include <directfb.h>

#include <core/system.h>
#include <pthread.h>


static long long     t1, t2;
static FusionWorld  *world;

void fusionObjectDestructor(FusionObject *object, bool zombie )
{
    fusion_object_destroy(object);
}

static void
bench_fusion_property( bool debug )
{
     DirectResult  ret=0;
     FusionHash *hash;
     FusionObjectPool *pool;
     FusionObject  *obj;
     
     pool =fusion_object_pool_create ("prop pool",sizeof(FusionObject),10,fusionObjectDestructor,world);

     if (!pool) {
          DirectFBError( "fusion_object_pool_create() failed", ret );
          return;
     }

     obj = fusion_object_create(pool, world); 
     if (!obj) {
          DirectFBError( "fusion_object_create() failed", ret );
          return;
     }
     printf(" HASH INSERT VAL %d \n",42);
     fusion_object_set_property(obj,"Hello","World",NULL);
     {
       char * val = fusion_object_get_property(obj,"Hello");
       printf(" FOUND PROPERTY %s \n",val);
     }
}


static void
bench_fusion_hash( bool debug )
{
     DirectResult  ret;
     FusionHash *hash;
     FusionSHMPoolShared *pool;

     ret = fusion_shm_pool_create( world, "Benchmark Pool", 524288, debug, &pool );
     if (ret) {
          DirectFBError( "fusion_shm_pool_create() failed", ret );
          return;
     }
     ret= fusion_hash_create(pool,HASH_INT,HASH_INT,21,&hash);
     if (ret) {
          DirectFBError( "fusion_hash_create() failed", ret );
          return;
     }
     printf(" HASH INSERT VAL %d \n",42);
     fusion_hash_insert(hash,(void *)32,(void *)42);
     {
       int val = (int)fusion_hash_lookup(hash,(void *)32);
       printf(" HASH FOUND VAL %d \n",val);
     }
     fusion_hash_destroy(hash);

     ret= fusion_hash_create(pool,HASH_INT,HASH_INT,21,&hash);
     if (ret) {
          DirectFBError( "fusion_hash_create() failed", ret );
          return;
     }

     
}

int
main( int argc, char *argv[] )
{
     DirectResult ret;

     /* Initialize DirectFB. */
     ret = DirectFBInit( &argc, &argv );
     if (ret)
          return DirectFBError( "DirectFBInit()", ret );

     dfb_system_lookup();

     ret = fusion_enter( -1, 0, FER_MASTER, &world );
     if (ret)
          return DirectFBError( "fusion_enter()", ret );

     printf( "\n" );

#if FUSION_BUILD_MULTI
     printf( "Fusion Benchmark (Multi Application Core)\n" );
#else
     printf( "Fusion Benchmark (Single Application Core)\n" );
#endif
     printf( "\n" );
     bench_fusion_hash(true);
     bench_fusion_property(true);
     fusion_exit( world, false );
     printf( "Done Testing\n" );

     return 0;
}

