# This tries to push the hilbert transform for ssb demod back into the
# freq. xlating filter.
#
# The usual gnuradio copyright notice is hereby included by reference.
#
# The starting point for this was weaver_isb_am1_usrp3.py.
#
# The tap coefficients for freq_xlating_fir_filter_ccf were generated
# externally and are read from a file because I didn't want to learn how
# to make fir filters with arbitrary phase response using python numeric
# facilities.
#
# They were generated using Scilab which I am already familiar with.


from gnuradio import gr, gru
from gnuradio import audio
from gnuradio import usrp

class ssb_demod( gr.hier_block ):
    def __init__( self, fg, if_rate, af_rate ):

        self.if_rate  = if_rate
        self.af_rate  = af_rate
        self.if_decim = if_rate / af_rate
        self.sideband = 1

        self.xlate_taps = ([complex(v) for v in file('f').readlines()])
        
        self.audio_taps = gr.firdes.low_pass(
            1.0,
            self.af_rate,
            3e3,
            600,
            gr.firdes.WIN_HAMMING )

        self.xlate = gr.freq_xlating_fir_filter_ccc(
            self.if_decim,
            self.xlate_taps,
            0,
            self.if_rate )

        self.split = gr.complex_to_float()

        self.lpf = gr.fir_filter_fff(
            1, self.audio_taps )

        self.sum   = gr.add_ff( )

                
        fg.connect(   self.xlate,       self.split   )
        fg.connect( ( self.split,0 ), ( self.sum,0 ) )
        fg.connect( ( self.split,1 ), ( self.sum,1 ) )
        fg.connect(    self.sum,        self.lpf     )
        
        gr.hier_block.__init__( self, fg, self.xlate, self.lpf )

    def upper_sb( self ):
        self.xlate.set_taps([v.conjugate() for v in self.xlate_taps])
        
    def lower_sb( self ):
        self.xlate.set_taps(self.xlate_taps)

    def tune( self, freq ):
        self.xlate.set_center_freq( freq )

