#!/usr/bin/env python2
##################################################
# GNU Radio Python Flow Graph
# Title: Dummy BER Simulation
# Author: Johannes Demel
# Generated: Thu Oct  8 18:09:28 2015
##################################################

from gnuradio import analog
from gnuradio import blocks
from gnuradio import digital
from gnuradio import eng_notation
from gnuradio import fec
from gnuradio import gr
from gnuradio.eng_option import eng_option
from gnuradio.filter import firdes
from optparse import OptionParser
import numpy as np


class dummy_ber_simulation(gr.top_block):

    def __init__(self, bit_seed=0, block_size=1024, ebno=9.0, noise_seed=0, sig_ampl=1.0, min_error_count=2 ** 17):
        gr.top_block.__init__(self, "Dummy BER Simulation")

        ##################################################
        # Parameters
        ##################################################
        self.bit_seed = bit_seed
        self.block_size = block_size
        self.ebno = ebno
        self.noise_seed = noise_seed
        self.sig_ampl = sig_ampl
        self.min_error_count = min_error_count

        ##################################################
        # Variables
        ##################################################
        self.code_rate = code_rate = 1.0
        self.snr = snr = ebno + 10 * np.log10(code_rate)
        self.noise_ampl = noise_ampl = sig_ampl / (10 ** (snr / 20))
        
        
        self.dummy_encoder = dummy_encoder = fec.dummy_encoder_make(block_size)
            
        
        
        self.dummy_decoder = dummy_decoder = fec.dummy_decoder.make(block_size)
            

        ##################################################
        # Blocks
        ##################################################
        self.rng_src = analog.random_uniform_source_b(0, 2, bit_seed)
        self.null_sink = blocks.null_sink(gr.sizeof_float*1)
        self.noise_float_source = analog.noise_source_f(analog.GR_GAUSSIAN, noise_ampl, noise_seed)
        self.map_to_NRZ = digital.map_bb(([-1, 1]))
        self.extended_encoder = fec.extended_encoder(encoder_obj_list=dummy_encoder, threading= None, puncpat='11')
        self.extended_decoder = fec.extended_decoder(decoder_obj_list=dummy_decoder, threading= None, ann=None, puncpat='11', integration_period=10000)
        self.char_to_float = blocks.char_to_float(1, 1)
        self.ber_counter = fec.ber_bf(True, min_error_count, -100.0)
        self.add_floats = blocks.add_vff(1)

        ##################################################
        # Connections
        ##################################################
        self.connect((self.add_floats, 0), (self.extended_decoder, 0))    
        self.connect((self.ber_counter, 0), (self.null_sink, 0))    
        self.connect((self.char_to_float, 0), (self.add_floats, 0))    
        self.connect((self.extended_decoder, 0), (self.ber_counter, 0))    
        self.connect((self.extended_encoder, 0), (self.map_to_NRZ, 0))    
        self.connect((self.map_to_NRZ, 0), (self.char_to_float, 0))    
        self.connect((self.noise_float_source, 0), (self.add_floats, 1))    
        self.connect((self.rng_src, 0), (self.ber_counter, 1))    
        self.connect((self.rng_src, 0), (self.extended_encoder, 0))    

    def get_bit_seed(self):
        return self.bit_seed

    def set_bit_seed(self, bit_seed):
        self.bit_seed = bit_seed

    def get_block_size(self):
        return self.block_size

    def set_block_size(self, block_size):
        self.block_size = block_size

    def get_ebno(self):
        return self.ebno

    def set_ebno(self, ebno):
        self.ebno = ebno
        self.set_snr(self.ebno + 10 * np.log10(self.code_rate))

    def get_noise_seed(self):
        return self.noise_seed

    def set_noise_seed(self, noise_seed):
        self.noise_seed = noise_seed

    def get_sig_ampl(self):
        return self.sig_ampl

    def set_sig_ampl(self, sig_ampl):
        self.sig_ampl = sig_ampl
        self.set_noise_ampl(self.sig_ampl / (10 ** (self.snr / 20)))

    def get_min_error_count(self):
        return self.min_error_count

    def set_min_error_count(self, min_error_count):
        self.min_error_count = min_error_count

    def get_code_rate(self):
        return self.code_rate

    def set_code_rate(self, code_rate):
        self.code_rate = code_rate
        self.set_snr(self.ebno + 10 * np.log10(self.code_rate))

    def get_snr(self):
        return self.snr

    def set_snr(self, snr):
        self.snr = snr
        self.set_noise_ampl(self.sig_ampl / (10 ** (self.snr / 20)))

    def get_noise_ampl(self):
        return self.noise_ampl

    def set_noise_ampl(self, noise_ampl):
        self.noise_ampl = noise_ampl
        self.noise_float_source.set_amplitude(self.noise_ampl)

    def get_dummy_encoder(self):
        return self.dummy_encoder

    def set_dummy_encoder(self, dummy_encoder):
        self.dummy_encoder = dummy_encoder

    def get_dummy_decoder(self):
        return self.dummy_decoder

    def set_dummy_decoder(self, dummy_decoder):
        self.dummy_decoder = dummy_decoder


def argument_parser():
    parser = OptionParser(option_class=eng_option, usage="%prog: [options]")
    parser.add_option(
        "", "--bit-seed", dest="bit_seed", type="intx", default=0,
        help="Set Bit Seed [default=%default]")
    parser.add_option(
        "", "--block-size", dest="block_size", type="intx", default=1024,
        help="Set Polar Code block size [default=%default]")
    parser.add_option(
        "", "--ebno", dest="ebno", type="eng_float", default=eng_notation.num_to_str(9.0),
        help="Set Eb/No [default=%default]")
    parser.add_option(
        "", "--noise-seed", dest="noise_seed", type="intx", default=0,
        help="Set Noise Seed [default=%default]")
    parser.add_option(
        "", "--sig-ampl", dest="sig_ampl", type="eng_float", default=eng_notation.num_to_str(1.0),
        help="Set Signal Amplitude [default=%default]")
    parser.add_option(
        "", "--min-error-count", dest="min_error_count", type="intx", default=2 ** 17,
        help="Set Minimum Errors [default=%default]")
    return parser


def main(top_block_cls=dummy_ber_simulation, options=None):
    if options is None:
        options, _ = argument_parser().parse_args()

    tb = top_block_cls(bit_seed=options.bit_seed, block_size=options.block_size, ebno=options.ebno, noise_seed=options.noise_seed, sig_ampl=options.sig_ampl, min_error_count=options.min_error_count)
    tb.start()
    tb.wait()


if __name__ == '__main__':
    main()
