#!/usr/bin/env python

from SimulationThread import *


def get_ebnos(min_ebno, max_ebno, step_size):
    n_vals = ((max_ebno - min_ebno) / step_size) + 1
    ebnos = np.linspace(min_ebno, max_ebno, n_vals)
    return ebnos


def extend_ebnos(ebnos):
    return np.append(ebnos, ebnos[-1] + (ebnos[1] - ebnos[0]))


def simulate_dummy_comparison_parallel(ebnos):
    # rate will be 1!
    sims = []
    kwargs = get_dummy_kwargs(ebnos[0])
    sims.append(start_ber_curve_simulation(ebnos, kwargs))
    monitor_simulation(sims, 'Dummy reference')


def main():
    # compare_algos()
    min_ebno = 2.0
    max_ebno = 6.25
    step_size = .25
    ebnos = get_ebnos(min_ebno, max_ebno, step_size)

    simulate_turbo_comparison_parallel(ebnos)


if __name__ == '__main__':
    main()
