/* 
   Tester for TableView
   Copyright (C) 2004 Free Software Foundation, Inc.

   Written by: Fred Kiefer <FredKiefer@gmx.de>
   Created: June 2004

   This file is part of the GNUstep Base Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <AppKit/AppKit.h>
#include "MyDelegate.h"
#include "MyTableView.h"
#include "MyComboBoxCell.h"

@implementation MyDelegate

- (void) _createMainMenu
{
  NSMenu *menu;
  NSMenu *info;

  //	Create the app menu
  menu = [NSMenu new];

  [menu addItemWithTitle: @"Info"
		  action: NULL
	   keyEquivalent: @""];
  [menu addItemWithTitle: @"Hide"
		  action: @selector(hide:)
	   keyEquivalent: @"h"];
  [menu addItemWithTitle: @"Quit"
		  action: @selector(terminate:)
	   keyEquivalent: @"q"];

  // Create the info submenu
  info = [NSMenu new];
  [info addItemWithTitle: @"Info Panel..."
	          action: @selector(orderFrontStandardInfoPanel:)
	   keyEquivalent: @""];
/*  
  [info addItemWithTitle: @"Preferences..."
		  action: NULL
	   keyEquivalent: @""];
*/
  [info addItemWithTitle: @"Help"
		  action: @selector (orderFrontHelpPanel:)
	   keyEquivalent: @"?"];
  [menu setSubmenu: info
	   forItem: [menu itemWithTitle: @"Info"]];
  [info release];


  [NSApp setMainMenu: menu];
  [menu release];
}


- (void) _createWindow
{
  NSWindow *aWin;
  NSTableView *tableView;
  NSScrollView *scrollView;
  NSTableColumn *testColumn;
  NSComboBoxCell *combo;

  aWin = [[NSWindow alloc] initWithContentRect: NSMakeRect(200, 200, 240, 240)
			   styleMask: NSTitledWindowMask
			   backing: NSBackingStoreBuffered
			   defer: NO];
  [aWin setBackgroundColor: [NSColor blueColor]];

  tableView = [[MyTableView alloc] initWithFrame: NSMakeRect(0, 0, 200, 200)];
  [tableView setDataSource: self];
  //[tableView setDelegate: self];
  [tableView setAllowsMultipleSelection: YES];
  [tableView setBackgroundColor: [NSColor lightGrayColor]];
  [tableView setAction: @selector(didClick:)];
  [tableView setTarget: self];

  testColumn = [[NSTableColumn alloc] initWithIdentifier: @"number"];
  [testColumn setEditable: YES];
  [[testColumn headerCell] setStringValue: @"number"];
  [testColumn setMinWidth: 20];
  [tableView addTableColumn: testColumn];
  [testColumn release];

  testColumn = [[NSTableColumn alloc] initWithIdentifier: @"combo"];
  [testColumn setEditable: YES];
  [[testColumn headerCell] setStringValue: @"combo"];
  [testColumn setMinWidth: 70];
  
  combo = [[MyComboBoxCell alloc] init];
  [testColumn setDataCell: combo];
  [combo release];
  [tableView addTableColumn: testColumn];
  [testColumn release];

  scrollView = [[NSScrollView alloc] 
		 initWithFrame: NSMakeRect (20, 20, 200, 200)];
  [scrollView setDocumentView: tableView];
  [tableView release];
  [scrollView setHasHorizontalScroller: YES];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setBorderType: NSBezelBorder];
  [scrollView setAutoresizingMask: (NSViewWidthSizable 
				    | NSViewHeightSizable)];

  [[aWin contentView] addSubview: scrollView];
  [scrollView release];
  [aWin makeKeyAndOrderFront: nil];
}

- (void)applicationWillFinishLaunching:(NSNotification *)not
{
  [self _createMainMenu];
  [self _createWindow];
}

- (int) numberOfRowsInTableView: (NSTableView *)aTableView
{
  return 5;
}
- (id)           tableView: (NSTableView *)aTableView 
 objectValueForTableColumn: (NSTableColumn *)aTableColumn 
		       row: (int)rowIndex
{
    return [NSString stringWithFormat: @"%d", rowIndex];
}

- (void) tableView: (NSTableView *)aTableView 
    setObjectValue: (id)aValue
    forTableColumn: (NSTableColumn *)aTableColumn 
	       row: (int)rowIndex
{
  NSLog(@"Did get new value %@", aValue);
}

- (void) didClick: (id)sender
{
  NSLog(@"Did get click from %@", sender);
}

- (void) didDoubleClick: (id)sender
{
  NSLog(@"Did get double click from %@", sender);
}
@end
